/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.util.lang.Checks;
import cdc.validation.checkers.Checker;

public final class IsInstanceOf
implements Checker<Object> {
    private final Class<?> cls;
    public static final FormalArg<Class> CLASS = new FormalArg("class", Class.class, Necessity.MANDATORY);
    public static final FormalArgs FARGS = new FormalArgs(new FormalArg[]{CLASS});
    public static final Factory<IsInstanceOf> FACTORY = new AbstractFactory<IsInstanceOf>(IsInstanceOf.class, new FormalArgs[]{FARGS}){

        protected IsInstanceOf create(Args args, FormalArgs fargs) {
            return new IsInstanceOf((Class)args.getValue(CLASS));
        }
    };

    public IsInstanceOf(Class<?> cls) {
        Checks.isNotNull(cls, (String)"cls");
        this.cls = cls;
    }

    @Override
    public Class<Object> getValueClass() {
        return Object.class;
    }

    @Override
    public boolean test(Object value) {
        return this.cls.isInstance(value);
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + " is instance of " + this.cls.getCanonicalName();
        }
        return this.wrap(arg) + " is not instance of " + this.cls.getCanonicalName();
    }

    public static IsInstanceOf from(Class<?> cls) {
        return new IsInstanceOf(cls);
    }
}

