/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.ComparablesSupport;

public class IsLessThan<T extends Comparable<T>>
implements Checker<T> {
    private final Class<T> valueClass;
    private final T max;
    public static final FormalArg<Class> CLASS = ComparablesSupport.CLASS;
    public static final FormalArg<String> SMAX = ComparablesSupport.MANDATORY_STRING_MAX;
    public static final FormalArg<Comparable> CMAX = ComparablesSupport.MANDATORY_COMPARABLE_MAX;
    public static final FormalArgs SFARGS = new FormalArgs(new FormalArg[]{CLASS, SMAX});
    public static final FormalArgs CFARGS = new FormalArgs(new FormalArg[]{CLASS, CMAX});
    public static final Factory<IsLessThan> FACTORY = new AbstractFactory<IsLessThan>(IsLessThan.class, new FormalArgs[]{SFARGS, CFARGS}){

        protected IsLessThan<?> create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)SFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable maxValue = ComparablesSupport.getMaxFromString(args, cls);
                return new IsLessThan<Comparable>(cls, maxValue);
            }
            if (fargs.equals((Object)CFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable maxValue = ComparablesSupport.getMaxFromComparable(args, cls);
                return new IsLessThan<Comparable>(cls, maxValue);
            }
            throw new IllegalArgumentException();
        }
    };

    public IsLessThan(Class<T> valueClass, T max) {
        this.valueClass = valueClass;
        this.max = max;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean test(T value) {
        return value != null && value.compareTo(this.max) < 0;
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + "<" + this.max + ComparablesSupport.valueInfo(arg, this);
        }
        return this.wrap(arg) + ">=" + this.max + ComparablesSupport.valueInfo(arg, this);
    }

    public T getMax() {
        return this.max;
    }

    public static IsLessThan<String> from(String max) {
        return new IsLessThan<String>(String.class, max);
    }

    public static IsLessThan<Character> from(char max) {
        return new IsLessThan<Character>(Character.class, Character.valueOf(max));
    }

    public static IsLessThan<Double> from(double max) {
        return new IsLessThan<Double>(Double.class, max);
    }

    public static IsLessThan<Float> from(float max) {
        return new IsLessThan<Float>(Float.class, Float.valueOf(max));
    }

    public static IsLessThan<Long> from(long max) {
        return new IsLessThan<Long>(Long.class, max);
    }

    public static IsLessThan<Integer> from(int max) {
        return new IsLessThan<Integer>(Integer.class, max);
    }

    public static IsLessThan<Short> from(short max) {
        return new IsLessThan<Short>(Short.class, max);
    }

    public static IsLessThan<Byte> from(byte max) {
        return new IsLessThan<Byte>(Byte.class, max);
    }
}

