/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers;

import cdc.args.Factories;
import cdc.util.debug.Printable;
import cdc.util.debug.Printables;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.NotFoundException;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.HasNoDoubleSpaces;
import cdc.validation.checkers.defaults.HasNoInnerSpaces;
import cdc.validation.checkers.defaults.HasNoOuterSpaces;
import cdc.validation.checkers.defaults.HasNoSpaces;
import cdc.validation.checkers.defaults.IsConvertibleUsing;
import cdc.validation.checkers.defaults.IsExistingDirectory;
import cdc.validation.checkers.defaults.IsExistingFile;
import cdc.validation.checkers.defaults.IsGreaterOrEqual;
import cdc.validation.checkers.defaults.IsGreaterThan;
import cdc.validation.checkers.defaults.IsInRange;
import cdc.validation.checkers.defaults.IsInstanceOf;
import cdc.validation.checkers.defaults.IsLessOrEqual;
import cdc.validation.checkers.defaults.IsLessThan;
import cdc.validation.checkers.defaults.IsNotNull;
import cdc.validation.checkers.defaults.IsPattern;
import cdc.validation.checkers.defaults.LengthIsInRange;
import cdc.validation.checkers.defaults.MatchesPattern;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Checkers {
    private static final Logger LOGGER = LogManager.getLogger(Checkers.class);
    private static final Map<String, Checker<?>> MAP = new HashMap();
    public static final Printable PRINTER = new Printer();

    private Checkers() {
    }

    public static boolean elaborate() {
        return true;
    }

    public static void register(Checker<?> checker, String name) {
        LOGGER.debug("register({}, {})", (Object)name, checker);
        Checks.isNotNullOrEmpty((String)name, (String)"name");
        Checks.isNotNull(checker, (String)"checker");
        if (MAP.containsKey(name)) {
            throw new IllegalArgumentException("A checker named '" + name + "' is already registered");
        }
        MAP.put(name, checker);
    }

    public static Set<String> getNames() {
        return MAP.keySet();
    }

    public static boolean hasChecker(String name) {
        return MAP.containsKey(name);
    }

    public static Checker<?> getChecker(String name, FailureReaction reaction) {
        return (Checker)NotFoundException.onResult(MAP.get(name), (String)("No '" + name + "' checker found"), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static Checker<?> getChecker(String name) {
        return Checkers.getChecker(name, FailureReaction.FAIL);
    }

    public static <T> Checker<? super T> getChecker(Class<T> valueClass, String name, FailureReaction reaction) {
        Checks.isNotNull(valueClass, (String)"valueClass");
        Checker<?> tmp = Checkers.getChecker(name, reaction);
        if (tmp != null && !tmp.getValueClass().isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException("Non compliant class " + valueClass + " with " + tmp.getValueClass());
        }
        return tmp;
    }

    static {
        Printables.register(Checkers.class, (Printable)PRINTER);
        Factories.register(HasNoDoubleSpaces.FACTORY);
        Factories.register(HasNoInnerSpaces.FACTORY);
        Factories.register(HasNoOuterSpaces.FACTORY);
        Factories.register(HasNoSpaces.FACTORY);
        Factories.register(IsConvertibleUsing.FACTORY);
        Factories.register(IsExistingDirectory.FACTORY);
        Factories.register(IsExistingFile.FACTORY);
        Factories.register(IsGreaterOrEqual.FACTORY);
        Factories.register(IsGreaterThan.FACTORY);
        Factories.register(IsInRange.FACTORY);
        Factories.register(IsInstanceOf.FACTORY);
        Factories.register(IsLessOrEqual.FACTORY);
        Factories.register(IsLessThan.FACTORY);
        Factories.register(IsNotNull.FACTORY);
        Factories.register(IsPattern.FACTORY);
        Factories.register(LengthIsInRange.FACTORY);
        Factories.register(MatchesPattern.FACTORY);
        Checkers.register(HasNoDoubleSpaces.INSTANCE, "HasNoDoubleSpaces");
        Checkers.register(HasNoInnerSpaces.INSTANCE, "HasNoInnerSpaces");
        Checkers.register(HasNoOuterSpaces.INSTANCE, "HasNoOuterSpaces");
        Checkers.register(HasNoSpaces.INSTANCE, "HasNoSpaces");
        Checkers.register(IsConvertibleUsing.STRING_IS_DOUBLE, "IsDouble");
        Checkers.register(IsConvertibleUsing.STRING_IS_FLOAT, "IsFloat");
        Checkers.register(IsConvertibleUsing.STRING_IS_LONG, "IsLong");
        Checkers.register(IsConvertibleUsing.STRING_IS_INTEGER, "IsInteger");
        Checkers.register(IsConvertibleUsing.STRING_IS_SHORT, "IsShort");
        Checkers.register(IsConvertibleUsing.STRING_IS_BYTE, "IsByte");
        Checkers.register(IsConvertibleUsing.STRING_IS_BOOLEAN, "IsBoolean");
        Checkers.register(IsExistingDirectory.INSTANCE, "IsExistingDirectory");
        Checkers.register(IsExistingFile.INSTANCE, "IsExistingFile");
        Checkers.register(IsNotNull.INSTANCE, "IsNotNull");
        Checkers.register(IsPattern.INSTANCE, "IsPattern");
        Checkers.register(MatchesPattern.LETTERS, "Letters");
        Checkers.register(MatchesPattern.DIGITS, "Digits");
        Checkers.register(MatchesPattern.LETTERS_OR_DIGITS, "LettersOrDigits");
        Checkers.register(MatchesPattern.LC_LETTERS, "LowerCaseLetters");
        Checkers.register(MatchesPattern.LC_LETTERS_OR_DIGITS, "LowerCaseLettersOrDigits");
        Checkers.register(MatchesPattern.UC_LETTERS, "UpperCaseLetters");
        Checkers.register(MatchesPattern.UC_LETTERS_OR_DIGITS, "UpperCaseLettersOrDigits");
    }

    protected static class Printer
    implements Printable {
        protected Printer() {
        }

        public void print(PrintStream out, int level) {
            this.indent(out, level);
            out.println("Checkers (" + Checkers.getNames().size() + ")");
            for (String name : CollectionUtils.toSortedList(Checkers.getNames())) {
                Checker<?> checker = Checkers.getChecker(name);
                this.indent(out, level + 1);
                out.println(checker.getValueClass());
                this.indent(out, level + 2);
                out.println("explanation: " + checker.explain());
            }
        }
    }
}

