/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.ConversionException;
import cdc.converters.Converter;
import cdc.converters.Converters;
import cdc.converters.defaults.StringToBoolean;
import cdc.converters.defaults.StringToByte;
import cdc.converters.defaults.StringToDouble;
import cdc.converters.defaults.StringToFloat;
import cdc.converters.defaults.StringToInteger;
import cdc.converters.defaults.StringToLong;
import cdc.converters.defaults.StringToShort;
import cdc.util.lang.Introspection;
import cdc.validation.checkers.Checker;

public class IsConvertibleUsing<T>
implements Checker<T> {
    private final Converter<T, ?> converter;
    public static final FormalArg<Converter<?, ?>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FARGS1 = new FormalArgs(new FormalArg[]{CONVERTER});
    public static final FormalArg<String> NAME = new FormalArg("converter", String.class, Necessity.MANDATORY);
    public static final FormalArgs FARGS2 = new FormalArgs(new FormalArg[]{NAME});
    public static final Factory<IsConvertibleUsing> FACTORY = new AbstractFactory<IsConvertibleUsing>(IsConvertibleUsing.class, new FormalArgs[]{FARGS1, FARGS2}){

        protected IsConvertibleUsing create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)FARGS1)) {
                Converter rconverter = (Converter)args.getValue(CONVERTER);
                Converter tmp = (Converter)Converter.class.cast(rconverter);
                return new IsConvertibleUsing(tmp);
            }
            if (fargs.equals((Object)FARGS2)) {
                String name = (String)args.getValue(NAME);
                Converter rconverter = Converters.getConverter((String)name);
                Converter tmp = (Converter)Converter.class.cast(rconverter);
                return new IsConvertibleUsing(tmp);
            }
            throw new IllegalArgumentException();
        }
    };
    public static final IsConvertibleUsing<String> STRING_IS_DOUBLE = new IsConvertibleUsing(StringToDouble.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_FLOAT = new IsConvertibleUsing(StringToFloat.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_LONG = new IsConvertibleUsing(StringToLong.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_INTEGER = new IsConvertibleUsing(StringToInteger.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_SHORT = new IsConvertibleUsing(StringToShort.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_BYTE = new IsConvertibleUsing(StringToByte.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_BOOLEAN = new IsConvertibleUsing(StringToBoolean.INSTANCE);

    public IsConvertibleUsing(Converter<T, ?> converter) {
        this.converter = converter;
    }

    @Override
    public Class<T> getValueClass() {
        return this.converter.getSourceClass();
    }

    @Override
    public boolean test(T value) {
        try {
            this.converter.apply(value);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + " is convertible to " + this.converter.getTargetClass().getSimpleName();
        }
        return this.wrap(arg) + " is not convertible to " + this.converter.getTargetClass().getSimpleName();
    }
}

