/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.ComparablesSupport;

public class IsGreaterThan<T extends Comparable<T>>
implements Checker<T> {
    private final Class<T> valueClass;
    private final T min;
    public static final FormalArg<Class> CLASS = ComparablesSupport.CLASS;
    public static final FormalArg<String> SMIN = ComparablesSupport.MANDATORY_STRING_MIN;
    public static final FormalArg<Comparable> CMIN = ComparablesSupport.MANDATORY_COMPARABLE_MIN;
    public static final FormalArgs SFARGS = new FormalArgs(new FormalArg[]{CLASS, SMIN});
    public static final FormalArgs CFARGS = new FormalArgs(new FormalArg[]{CLASS, CMIN});
    public static final Factory<IsGreaterThan> FACTORY = new AbstractFactory<IsGreaterThan>(IsGreaterThan.class, new FormalArgs[]{SFARGS, CFARGS}){

        protected IsGreaterThan<?> create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)SFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromString(args, cls);
                return new IsGreaterThan<Comparable>(cls, minValue);
            }
            if (fargs.equals((Object)CFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromComparable(args, cls);
                return new IsGreaterThan<Comparable>(cls, minValue);
            }
            throw new IllegalArgumentException();
        }
    };

    public IsGreaterThan(Class<T> valueClass, T min) {
        this.valueClass = valueClass;
        this.min = min;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean test(T value) {
        return value != null && value.compareTo(this.min) > 0;
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + ">" + this.min + ComparablesSupport.valueInfo(arg, this);
        }
        return this.wrap(arg) + "<=" + this.min + ComparablesSupport.valueInfo(arg, this);
    }

    public T getMin() {
        return this.min;
    }

    public static IsGreaterThan<String> from(String min) {
        return new IsGreaterThan<String>(String.class, min);
    }

    public static IsGreaterThan<Character> from(char min) {
        return new IsGreaterThan<Character>(Character.class, Character.valueOf(min));
    }

    public static IsGreaterThan<Double> from(double min) {
        return new IsGreaterThan<Double>(Double.class, min);
    }

    public static IsGreaterThan<Float> from(float min) {
        return new IsGreaterThan<Float>(Float.class, Float.valueOf(min));
    }

    public static IsGreaterThan<Long> from(long min) {
        return new IsGreaterThan<Long>(Long.class, min);
    }

    public static IsGreaterThan<Integer> from(int min) {
        return new IsGreaterThan<Integer>(Integer.class, min);
    }

    public static IsGreaterThan<Short> from(short min) {
        return new IsGreaterThan<Short>(Short.class, min);
    }

    public static IsGreaterThan<Byte> from(byte min) {
        return new IsGreaterThan<Byte>(Byte.class, min);
    }
}

