/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation;

import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import cdc.validation.ValidationHandler;
import cdc.validation.Validator;
import cdc.validation.Validity;
import cdc.validation.checkers.Checker;

public class ValidatorImpl<T>
implements Validator<T> {
    private final Class<T> valueClass;
    private final Checker<? super T> error;
    private final Checker<? super T> warning;

    public ValidatorImpl(Class<T> valueClass, Checker<? super T> error, Checker<? super T> warning) {
        Checks.isNotNull(valueClass, (String)"valueClass");
        this.valueClass = valueClass;
        this.error = error;
        this.warning = warning;
    }

    public static ValidatorImpl<?> createUnchecked(Checker<?> error, Checker<?> warning) {
        Class valueClass;
        if (error == null) {
            valueClass = warning == null ? Object.class : warning.getValueClass();
        } else if (warning == null) {
            valueClass = error.getValueClass();
        } else {
            valueClass = Introspection.mostGeneralized(error.getValueClass(), warning.getValueClass());
            if (valueClass == null) {
                throw new IllegalArgumentException("Can not create a validator with " + error.getValueClass().getCanonicalName() + " and " + warning.getValueClass().getCanonicalName());
            }
        }
        return new ValidatorImpl(Introspection.uncheckedCast(valueClass), (Checker)Introspection.uncheckedCast(error), (Checker)Introspection.uncheckedCast(warning));
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public String explainError(String name) {
        if (this.error == null) {
            return null;
        }
        return this.error.explain(name);
    }

    @Override
    public String explainWarning(String name) {
        if (this.warning == null) {
            return null;
        }
        return this.warning.explain(name);
    }

    @Override
    public void validate(T value, String name, ValidationHandler handler) {
        handler.begin();
        boolean hasNoError = this.isAccepted(value, name, handler, this.error, Validity.ERRONEOUS);
        if (hasNoError) {
            this.isAccepted(value, name, handler, this.warning, Validity.DUBIOUS);
        }
        handler.end();
    }

    private boolean isAccepted(T value, String name, ValidationHandler handler, Checker<? super T> checker, Validity validity) {
        if (checker == null) {
            return true;
        }
        boolean accepted = checker.test(value);
        if (!accepted) {
            String message = checker.explain(name);
            handler.processIssue(validity, message);
        }
        return accepted;
    }

    public Checker<? super T> getChecker(Validity validity) {
        Checks.isNotNull((Object)((Object)validity), (String)"validity");
        switch (validity) {
            case ERRONEOUS: {
                return this.error;
            }
            case DUBIOUS: {
                return this.warning;
            }
        }
        return null;
    }

    public boolean hasChecker(Validity validity) {
        Checks.isNotNull((Object)((Object)validity), (String)"validity");
        return this.getChecker(validity) != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[value class: ");
        builder.append(this.getValueClass().getSimpleName());
        if (this.error != null) {
            builder.append(", error: ");
            builder.append(this.explainError("'value'"));
        }
        if (this.warning != null) {
            builder.append(", warning: ");
            builder.append(this.explainWarning("'value'"));
        }
        builder.append("]");
        return builder.toString();
    }
}

