/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.checkers;

import cdc.converters.ConversionException;
import cdc.converters.Converter;
import cdc.util.lang.Checks;
import cdc.validation.checkers.CheckerSupport;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Checker<T>
extends Predicate<T> {
    public Class<T> getValueClass();

    @Override
    public boolean test(T var1);

    default public boolean testRaw(Object value) {
        T v = this.getValueClass().cast(value);
        return this.test(v);
    }

    public String explain(boolean var1, String var2);

    default public String explain(String arg) {
        return "expects " + this.explain(true, arg);
    }

    default public String explain() {
        return this.explain("value");
    }

    default public String testAndExplain(T value, String arg) {
        boolean result = this.test(value);
        return this.explain(result, arg);
    }

    default public String testAndExplainRaw(Object value, String arg) {
        boolean result = this.testRaw(value);
        return this.explain(result, arg);
    }

    default public String testAndExplain(T value) {
        return this.testAndExplain(value, Objects.toString(value));
    }

    default public String testAndExplainRaw(Object value) {
        return this.testAndExplainRaw(value, Objects.toString(value));
    }

    @Override
    default public Checker<T> negate() {
        return new Checker<T>(){

            @Override
            public boolean test(T value) {
                return !Checker.this.test(value);
            }

            @Override
            public Class<T> getValueClass() {
                return Checker.this.getValueClass();
            }

            @Override
            public String explain(boolean result, String arg) {
                return Checker.this.explain(!result, arg);
            }
        };
    }

    @Override
    default public Checker<T> and(final Checker<? super T> other) {
        Checks.isNotNull(other, (String)"other");
        return new Checker<T>(){

            @Override
            public boolean test(T value) {
                return Checker.this.test(value) && other.test(value);
            }

            @Override
            public Class<T> getValueClass() {
                return Checker.this.getValueClass();
            }

            @Override
            public String explain(boolean result, String arg) {
                return Checker.this.explain(result, arg) + (result ? " and " : " or ") + other.explain(result, arg);
            }
        };
    }

    default public <V> Checker<V> cast(Class<V> cls) {
        Checks.isNotNull(cls, (String)"cls");
        if (cls.isAssignableFrom(this.getValueClass())) {
            Checker tmp = this;
            return tmp;
        }
        throw new IllegalArgumentException(cls.getCanonicalName() + " not compliant with " + this.getValueClass().getCanonicalName());
    }

    default public Checker<T> cast(Checker<?> other) {
        Checks.isNotNull(other, (String)"other");
        return other.cast(this.getValueClass());
    }

    default public Checker<T> andRaw(Checker<?> other) {
        return this.and(this.cast(other));
    }

    default public Checker<T> orRaw(Checker<?> other) {
        return this.or(this.cast(other));
    }

    @Override
    default public Checker<T> or(final Checker<? super T> other) {
        Checks.isNotNull(other, (String)"other");
        return new Checker<T>(){

            @Override
            public boolean test(T value) {
                return Checker.this.test(value) || other.test(value);
            }

            @Override
            public Class<T> getValueClass() {
                return Checker.this.getValueClass();
            }

            @Override
            public String explain(boolean result, String arg) {
                return Checker.this.explain(result, arg) + (result ? " or " : " and ") + other.explain(result, arg);
            }
        };
    }

    default public <S> Checker<S> after(Converter<S, ? extends T> converter) {
        Checks.isNotNull(converter, (String)"converter");
        return this.after((Function<S, ? extends T>)converter, converter.getSourceClass());
    }

    default public Checker<?> afterRaw(Converter<?, ?> converter) {
        Converter tmp = converter.cast(converter.getSourceClass(), this.getValueClass());
        return this.after(tmp);
    }

    default public <S> Checker<S> after(final Function<S, ? extends T> function, final Class<S> sourceClass) {
        Checks.isNotNull(function, (String)"function");
        return new Checker<S>(){

            @Override
            public boolean test(S value) {
                try {
                    Object target = function.apply(value);
                    return Checker.this.test(target);
                }
                catch (ConversionException e) {
                    return false;
                }
            }

            @Override
            public Class<S> getValueClass() {
                return sourceClass;
            }

            @Override
            public String explain(boolean result, String arg) {
                if (result) {
                    return arg + " is convertible to " + Checker.this.getValueClass().getCanonicalName() + " and " + Checker.this.explain(true, arg);
                }
                return arg + " is not convertible to " + Checker.this.getValueClass().getCanonicalName() + " or " + Checker.this.explain(false, arg);
            }
        };
    }

    default public String wrap(String s) {
        return "'" + s + "'";
    }

    public static <S> Checker<S> fromConverter(Converter<S, ?> converter) {
        Checks.isNotNull(converter, (String)"converter");
        return CheckerSupport.fromFunctionUnchecked(converter, converter.getSourceClass(), converter.getTargetClass());
    }

    public static <S, T> Checker<S> fromFunction(Function<S, ?> function, Class<S> sourceClass, Class<T> targetClass) {
        Checks.isNotNull(function, (String)"function");
        Checks.isNotNull(sourceClass, (String)"sourceClass");
        Checks.isNotNull(targetClass, (String)"targetClass");
        return CheckerSupport.fromFunctionUnchecked(function, sourceClass, targetClass);
    }
}

