package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArgs;

public final class HasNoDoubleSpaces extends AbstractStringChecker {
    public static final HasNoDoubleSpaces INSTANCE = new HasNoDoubleSpaces();

    public static final Factory<HasNoDoubleSpaces> FACTORY =
            new AbstractFactory<HasNoDoubleSpaces>(HasNoDoubleSpaces.class) {
                @Override
                protected HasNoDoubleSpaces create(Args args,
                                                   FormalArgs fargs) {
                    return INSTANCE;
                }
            };

    @Override
    public boolean test(String value) {
        if (value == null) {
            return true;
        } else {
            int count = 0;
            final int length = value.length();
            for (int offset = 0; offset < length;) {
                final int codepoint = value.codePointAt(offset);
                if (Character.isSpaceChar(codepoint)) {
                    count++;
                    if (count == 2) {
                        return false;
                    }
                } else {
                    count = 0;
                }
                offset += Character.charCount(codepoint);
            }
            return true;
        }
    }

    @Override
    public String explain(boolean result,
                          String arg) {
        if (result) {
            return wrap(arg) + " has no double spaces";
        } else {
            return wrap(arg) + " has double spaces";
        }
    }
}