/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.validation;

import cdc.converters.Converter;
import cdc.converters.defaults.StringToInteger;
import cdc.util.lang.Introspection;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.IsInRange;
import cdc.validation.checkers.defaults.MatchesPattern;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckerTest {
    private static final Logger LOGGER = LogManager.getLogger(CheckerTest.class);

    CheckerTest() {
    }

    @Test
    void testNegate() {
        Checker checker = IsInRange.from((int)0, (int)100).negate();
        Assertions.assertTrue((boolean)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    void testAnd() {
        Checker checker = IsInRange.from((int)0, (int)100).and((Checker)IsInRange.from((int)50, (int)150));
        Assertions.assertTrue((boolean)checker.test((Object)75));
        Assertions.assertFalse((boolean)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    void testOr() {
        Checker checker = IsInRange.from((int)0, (int)100).or((Checker)IsInRange.from((int)50, (int)150));
        Assertions.assertTrue((boolean)checker.test((Object)75));
        Assertions.assertFalse((boolean)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    void testAfter() {
        Checker checker = IsInRange.from((int)10, (int)20).after((Converter)StringToInteger.INSTANCE);
        Assertions.assertTrue((boolean)checker.test((Object)"15"));
        Assertions.assertFalse((boolean)checker.test((Object)"30"));
        Assertions.assertFalse((boolean)checker.test((Object)"Hello"));
        LOGGER.debug(checker.explain());
    }

    @Test
    void testAndCombining() {
        Checker checker = Checker.and((Checker[])new Checker[]{IsInRange.from((int)10, (int)20), IsInRange.from((int)15, (int)25)});
        Assertions.assertTrue((boolean)checker.test((Object)15));
        Assertions.assertFalse((boolean)checker.test((Object)10));
        LOGGER.debug(checker.testAndExplain((Object)0));
    }

    @Test
    void testOrCombining() {
        Checker checker = Checker.or((Checker[])new Checker[]{IsInRange.from((int)10, (int)20), IsInRange.from((int)15, (int)25)});
        Assertions.assertTrue((boolean)checker.test((Object)15));
        Assertions.assertTrue((boolean)checker.test((Object)10));
        Assertions.assertFalse((boolean)checker.test((Object)100));
    }

    @Test
    void testCollectionChecker() {
        Checker checker = Checker.from((Class)Introspection.uncheckedCast(List.class), (Checker)MatchesPattern.DIGITS);
        Assertions.assertTrue((boolean)checker.test(List.of()));
        Assertions.assertTrue((boolean)checker.test(List.of("000")));
        Assertions.assertFalse((boolean)checker.test(List.of("A")));
        Assertions.assertFalse((boolean)checker.test(List.of("0", "A", "1")));
        LOGGER.debug(checker.testAndExplain(List.of("000")));
        LOGGER.debug(checker.testAndExplain(List.of("A")));
    }
}

