/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.validation;

import cdc.validation.checkers.defaults.HasNoDoubleSpaces;
import cdc.validation.checkers.defaults.HasNoOuterSpaces;
import cdc.validation.checkers.defaults.HasNoOuterWhiteSpaces;
import cdc.validation.checkers.defaults.HasNoSpaces;
import cdc.validation.checkers.defaults.HasNoWhiteSpaces;
import cdc.validation.checkers.defaults.IsInRange;
import cdc.validation.checkers.defaults.IsInstanceOf;
import cdc.validation.checkers.defaults.IsNotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckersDefaultTest {
    private static final Logger LOGGER = LogManager.getLogger(CheckersDefaultTest.class);

    CheckersDefaultTest() {
    }

    @Test
    void testIsNotNull() {
        Assertions.assertEquals((Object)false, (Object)IsNotNull.INSTANCE.test(null));
        Assertions.assertEquals((Object)true, (Object)IsNotNull.INSTANCE.test((Object)"Hello"));
        Assertions.assertEquals((Object)true, (Object)IsNotNull.INSTANCE.negate().test(null));
        Assertions.assertEquals((Object)false, (Object)IsNotNull.INSTANCE.negate().test((Object)"Hello"));
        LOGGER.debug(IsNotNull.INSTANCE.explain());
        LOGGER.debug(IsNotNull.INSTANCE.negate().explain());
        LOGGER.debug(IsNotNull.INSTANCE.testAndExplain(null));
        LOGGER.debug(IsNotNull.INSTANCE.testAndExplain((Object)"Hello"));
        LOGGER.debug(IsNotNull.INSTANCE.negate().testAndExplain(null));
        LOGGER.debug(IsNotNull.INSTANCE.negate().testAndExplain((Object)"Hello"));
    }

    @Test
    void testIsInRange() {
        Assertions.assertEquals((Object)true, (Object)IsInRange.from((int)0, (int)100).test((Comparable)Integer.valueOf(10)));
        Assertions.assertEquals((Object)false, (Object)IsInRange.from((int)0, (int)100).test((Comparable)Integer.valueOf(200)));
        LOGGER.debug(IsInRange.from((int)0, (int)100).explain());
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().explain());
        LOGGER.debug(IsInRange.from((int)0, (int)100).testAndExplain((Object)10));
        LOGGER.debug(IsInRange.from((int)0, (int)100).testAndExplain((Object)200));
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().testAndExplain((Object)10));
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().testAndExplain((Object)200));
    }

    @Test
    void testCharacter() {
        Assertions.assertTrue((boolean)Character.isSpaceChar(' '));
        Assertions.assertFalse((boolean)Character.isSpaceChar('\n'));
        Assertions.assertFalse((boolean)Character.isSpaceChar('\t'));
        Assertions.assertTrue((boolean)Character.isWhitespace(' '));
        Assertions.assertTrue((boolean)Character.isWhitespace('\n'));
        Assertions.assertTrue((boolean)Character.isWhitespace('\n'));
    }

    @Test
    void testIsInstanceOf() {
        IsInstanceOf checker = IsInstanceOf.from(String.class);
        Assertions.assertEquals((Object)false, (Object)checker.test(null));
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)"Hello"));
        LOGGER.debug(checker.explain());
    }

    @Test
    void testHasNoSpaces() {
        HasNoSpaces checker = HasNoSpaces.INSTANCE;
        Assertions.assertTrue((boolean)checker.test((Object)"a"));
        Assertions.assertFalse((boolean)checker.test((Object)"a a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\ta"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\na"));
    }

    @Test
    void testHasNoWhiteSpaces() {
        HasNoWhiteSpaces checker = HasNoWhiteSpaces.INSTANCE;
        Assertions.assertTrue((boolean)checker.test((Object)"a"));
        Assertions.assertFalse((boolean)checker.test((Object)"a a"));
        Assertions.assertFalse((boolean)checker.test((Object)"a\ta"));
        Assertions.assertFalse((boolean)checker.test((Object)"a\na"));
    }

    @Test
    void testHasNoOuterSpaces() {
        HasNoOuterSpaces checker = HasNoOuterSpaces.INSTANCE;
        Assertions.assertTrue((boolean)checker.test((Object)"a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\ta"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\na"));
        Assertions.assertFalse((boolean)checker.test((Object)"a "));
        Assertions.assertTrue((boolean)checker.test((Object)"a\n"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\t"));
        Assertions.assertFalse((boolean)checker.test((Object)" a"));
        Assertions.assertTrue((boolean)checker.test((Object)"\na"));
        Assertions.assertTrue((boolean)checker.test((Object)"\ta"));
    }

    @Test
    void testHasNoOuterWhiteSpaces() {
        HasNoOuterWhiteSpaces checker = HasNoOuterWhiteSpaces.INSTANCE;
        Assertions.assertTrue((boolean)checker.test((Object)"a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\ta"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\na"));
        Assertions.assertFalse((boolean)checker.test((Object)"a "));
        Assertions.assertFalse((boolean)checker.test((Object)"a\t"));
        Assertions.assertFalse((boolean)checker.test((Object)"a\n"));
        Assertions.assertFalse((boolean)checker.test((Object)" a"));
        Assertions.assertFalse((boolean)checker.test((Object)"\ta"));
        Assertions.assertFalse((boolean)checker.test((Object)"\na"));
    }

    @Test
    void testHasNoDoubleSpaces() {
        HasNoDoubleSpaces checker = HasNoDoubleSpaces.INSTANCE;
        Assertions.assertTrue((boolean)checker.test((Object)"a"));
        Assertions.assertTrue((boolean)checker.test((Object)"a "));
        Assertions.assertFalse((boolean)checker.test((Object)"a  "));
        Assertions.assertTrue((boolean)checker.test((Object)"a \n"));
        Assertions.assertTrue((boolean)checker.test((Object)"a\n "));
    }
}

