package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArgs;

/**
 * Specialization of {@link AbstractStringChecker} that checks that a string does not contain
 * any inner {@link Character#isSpaceChar(int) space} character.
 * <p>
 * Outer (leading and trailing) spaces are ignored.
 */
public final class HasNoInnerSpaces extends AbstractStringChecker {
    public static final HasNoInnerSpaces INSTANCE = new HasNoInnerSpaces();

    public static final Factory<HasNoInnerSpaces> FACTORY =
            new AbstractFactory<HasNoInnerSpaces>(HasNoInnerSpaces.class) {
                @Override
                protected HasNoInnerSpaces create(Args args,
                                                  FormalArgs fargs) {
                    return INSTANCE;
                }
            };

    @Override
    public boolean test(String value) {
        if (value == null) {
            return true;
        } else {
            return value.trim()
                        .codePoints()
                        .noneMatch(Character::isSpaceChar);
        }
    }

    @Override
    public String explain(boolean result,
                          String arg) {
        if (result) {
            return wrap(arg) + " has no inner spaces";
        } else {
            return wrap(arg) + " has inner spaces";
        }
    }
}