/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.validation;

import cdc.converters.Converter;
import cdc.converters.defaults.StringToDouble;
import cdc.validation.ValidationRecord;
import cdc.validation.Validator;
import cdc.validation.ValidatorImpl;
import cdc.validation.Validity;
import cdc.validation.checkers.Checker;
import cdc.validation.checkers.defaults.IsInRange;
import cdc.validation.checkers.defaults.IsNotNull;
import cdc.validation.checkers.defaults.LengthIsInRange;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ValidatorTest {
    private static final Logger LOGGER = LogManager.getLogger(ValidatorTest.class);

    ValidatorTest() {
    }

    private static <T> void checkValidate(Validator<T> validator, T value, Validity expected) {
        LOGGER.debug("checkValidate({}, {})", validator, value);
        List records = validator.validate(value, "value");
        for (ValidationRecord record : records) {
            LOGGER.debug("   {}", (Object)record);
        }
        Assertions.assertEquals((Object)expected, (Object)ValidationRecord.getValidity((List)records));
        Assertions.assertEquals((Object)expected, (Object)validator.getValidity(value));
    }

    private static <T> void checkValidateRaw(Validator<?> validator, Object value, Validity expected) {
        LOGGER.debug("checkValidateRaw({}, {})", validator, value);
        List records = validator.validateRaw(value, "value");
        for (ValidationRecord record : records) {
            LOGGER.debug("   {}", (Object)record);
        }
        Assertions.assertEquals((Object)expected, (Object)ValidationRecord.getValidity((List)records));
        Assertions.assertEquals((Object)expected, (Object)validator.getValidityRaw(value));
    }

    @Test
    void testNone() {
        ValidatorImpl validator = new ValidatorImpl(String.class, null, null);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.ERRONEOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.DUBIOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.VALID));
        ValidatorTest.checkValidate(validator, null, Validity.VALID);
        ValidatorTest.checkValidate(validator, "", Validity.VALID);
        ValidatorTest.checkValidate(validator, "Hello", Validity.VALID);
    }

    @Test
    void testError() {
        ValidatorImpl validator = new ValidatorImpl(String.class, (Checker)IsNotNull.INSTANCE, null);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        Assertions.assertEquals((Object)IsNotNull.INSTANCE, (Object)validator.getChecker(Validity.ERRONEOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.DUBIOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.VALID));
        ValidatorTest.checkValidate(validator, null, Validity.ERRONEOUS);
        ValidatorTest.checkValidate(validator, "", Validity.VALID);
        ValidatorTest.checkValidate(validator, "Hello", Validity.VALID);
    }

    @Test
    void testWarning() {
        ValidatorImpl validator = new ValidatorImpl(String.class, null, (Checker)IsNotNull.INSTANCE);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.ERRONEOUS));
        Assertions.assertEquals((Object)IsNotNull.INSTANCE, (Object)validator.getChecker(Validity.DUBIOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.VALID));
        ValidatorTest.checkValidate(validator, null, Validity.DUBIOUS);
        ValidatorTest.checkValidate(validator, "", Validity.VALID);
        ValidatorTest.checkValidate(validator, "Hello", Validity.VALID);
    }

    @Test
    void testErrorAndWarning() {
        LengthIsInRange warning = new LengthIsInRange(5, 10);
        ValidatorImpl validator = new ValidatorImpl(String.class, (Checker)IsNotNull.INSTANCE, (Checker)warning);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        Assertions.assertEquals((Object)IsNotNull.INSTANCE, (Object)validator.getChecker(Validity.ERRONEOUS));
        Assertions.assertEquals((Object)warning, (Object)validator.getChecker(Validity.DUBIOUS));
        Assertions.assertEquals(null, (Object)validator.getChecker(Validity.VALID));
        Assertions.assertTrue((boolean)validator.hasChecker(Validity.ERRONEOUS));
        Assertions.assertTrue((boolean)validator.hasChecker(Validity.DUBIOUS));
        Assertions.assertFalse((boolean)validator.hasChecker(Validity.VALID));
        ValidatorTest.checkValidate(validator, null, Validity.ERRONEOUS);
        ValidatorTest.checkValidate(validator, "", Validity.DUBIOUS);
        ValidatorTest.checkValidate(validator, "Hello", Validity.VALID);
        ValidatorTest.checkValidate(validator, "Much too long", Validity.DUBIOUS);
    }

    @Test
    void testAfter() {
        IsNotNull error = IsNotNull.INSTANCE;
        IsInRange warning = new IsInRange(Double.class, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(10.0));
        ValidatorImpl doubleValidator = new ValidatorImpl(Double.class, (Checker)error, (Checker)warning);
        Validator validator = doubleValidator.after((Converter)StringToDouble.INSTANCE);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        ValidatorTest.checkValidate(validator, null, Validity.ERRONEOUS);
        ValidatorTest.checkValidate(validator, "5.0", Validity.VALID);
        ValidatorTest.checkValidate(validator, "-10.0", Validity.DUBIOUS);
        ValidatorTest.checkValidate(validator, "20.0", Validity.DUBIOUS);
        ValidatorTest.checkValidate(validator, "Number", Validity.ERRONEOUS);
    }

    @Test
    void testAfterRaw() {
        IsNotNull error = IsNotNull.INSTANCE;
        IsInRange warning = new IsInRange(Double.class, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(10.0));
        ValidatorImpl doubleValidator = new ValidatorImpl(Double.class, (Checker)error, (Checker)warning);
        Validator validator = doubleValidator.afterRaw((Converter)StringToDouble.INSTANCE);
        Assertions.assertEquals(String.class, (Object)validator.getValueClass());
        ValidatorTest.checkValidateRaw(validator, null, Validity.ERRONEOUS);
        ValidatorTest.checkValidateRaw(validator, "5.0", Validity.VALID);
        ValidatorTest.checkValidateRaw(validator, "-10.0", Validity.DUBIOUS);
        ValidatorTest.checkValidateRaw(validator, "20.0", Validity.DUBIOUS);
        ValidatorTest.checkValidateRaw(validator, "Number", Validity.ERRONEOUS);
    }
}

