/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation;

import cdc.converters.Converter;
import cdc.util.lang.Checks;
import cdc.util.lang.ValueHolder;
import cdc.validation.ValidationHandler;
import cdc.validation.ValidationRecord;
import cdc.validation.Validity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public interface Validator<T> {
    public Class<T> getValueClass();

    public String explainError(String var1);

    public String explainWarning(String var1);

    public void validate(T var1, String var2, ValidationHandler var3);

    default public void validate(T value, String name, List<ValidationRecord> records) {
        Checks.isNotNull(records, (String)"records");
        this.validate(value, name, (Validity s, String m) -> records.add(new ValidationRecord(s, m)));
    }

    default public List<ValidationRecord> validate(T value, String name) {
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        this.validate(value, name, records);
        return records;
    }

    default public void validateRaw(Object value, String name, ValidationHandler handler) {
        T v = this.getValueClass().cast(value);
        this.validate(v, name, handler);
    }

    default public void validateRaw(Object value, String name, List<ValidationRecord> records) {
        Checks.isNotNull(records, (String)"records");
        this.validateRaw(value, name, (Validity s, String m) -> records.add(new ValidationRecord(s, m)));
    }

    default public List<ValidationRecord> validateRaw(Object value, String name) {
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        this.validateRaw(value, name, records);
        return records;
    }

    default public Validity getValidity(T value) {
        ValueHolder max = new ValueHolder((Object)Validity.VALID);
        this.validate(value, null, (Validity s, String m) -> {
            max.value = Validity.worse((Validity)((Object)((Object)max.value)), s);
        });
        return (Validity)((Object)max.value);
    }

    default public Validity getValidityRaw(Object value) {
        T v = this.getValueClass().cast(value);
        return this.getValidity(v);
    }

    default public <S> Validator<S> after(Converter<S, ? extends T> converter) {
        Checks.isNotNull(converter, (String)"converter");
        return this.after((Function<S, ? extends T>)converter, converter.getSourceClass());
    }

    default public Validator<?> afterRaw(Converter<?, ?> converter) {
        Checks.isNotNull(converter, (String)"converter");
        Converter tmp = converter.cast(converter.getSourceClass(), this.getValueClass());
        return this.after(tmp);
    }

    default public <S> Validator<S> after(final Function<S, ? extends T> function, final Class<S> sourceClass) {
        Checks.isNotNull(function, (String)"function");
        Checks.isNotNull(sourceClass, (String)"sourceClass");
        return new Validator<S>(){

            @Override
            public Class<S> getValueClass() {
                return sourceClass;
            }

            @Override
            public String explainError(String name) {
                String s1 = name + " must be convertible to " + Validator.this.getValueClass().getSimpleName();
                String s2 = Validator.this.explainError(name);
                if (s2 == null || s2.isEmpty()) {
                    return s1;
                }
                return s1 + " and " + s2;
            }

            @Override
            public String explainWarning(String name) {
                String s1 = name + " must be convertible to " + Validator.this.getValueClass().getSimpleName();
                String s2 = Validator.this.explainWarning(name);
                if (s2 == null || s2.isEmpty()) {
                    return s1;
                }
                return s1 + " and " + s2;
            }

            @Override
            public void validate(S value, String name, ValidationHandler handler) {
                Object target;
                try {
                    target = function.apply(value);
                }
                catch (Exception e) {
                    handler.begin();
                    handler.processIssue(Validity.ERRONEOUS, "Failed to convert '" + String.valueOf(value) + "'");
                    handler.end();
                    return;
                }
                Validator.this.validate(target, name, handler);
            }

            public String toString() {
                return "convert from " + sourceClass.getSimpleName() + " followed by: " + String.valueOf(Validator.this);
            }
        };
    }
}

