/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.cli;

import cdc.util.lang.FailureReaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class FeatureMask<E extends Enum<E>> {
    private final Set<E> features = new HashSet();

    public final void setEnabled(E feature, boolean enabled) {
        if (enabled) {
            this.features.add(feature);
        } else {
            this.features.remove(feature);
        }
    }

    public final void add(E feature) {
        this.features.add(feature);
    }

    @SafeVarargs
    public final void addAll(E ... features) {
        for (E feature : features) {
            this.add(feature);
        }
    }

    public final void remove(E feature) {
        this.features.remove(feature);
    }

    public final boolean isEnabled(E feature) {
        return this.features.contains(feature);
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public final boolean contains(E feature) {
        return this.features.contains(feature);
    }

    public final Set<E> toSet() {
        HashSet<E> set = new HashSet<E>();
        set.addAll(this.features);
        return set;
    }

    public final List<E> toList() {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(this.features);
        return list;
    }

    @SafeVarargs
    public final boolean checkAtMostOne(Logger logger, FailureReaction reaction, E ... features) {
        FeatureMask<E> other = new FeatureMask<E>();
        other.addAll((Enum[])features);
        other.features.retainAll(this.features);
        if (other.features.size() <= 1) {
            return true;
        }
        FailureReaction.onError((String)("Expected at most one enabled feature among " + Arrays.toString(features)), (Logger)logger, (FailureReaction)reaction, IllegalArgumentException::new);
        return false;
    }

    @SafeVarargs
    public final boolean checkExactlyOne(Logger logger, FailureReaction reaction, E ... features) {
        FeatureMask<E> other = new FeatureMask<E>();
        other.addAll((Enum[])features);
        other.features.retainAll(this.features);
        if (other.features.size() == 1) {
            return true;
        }
        FailureReaction.onError((String)("Expected exactly one enabled feature among " + Arrays.toString(features)), (Logger)logger, (FailureReaction)reaction, IllegalArgumentException::new);
        return false;
    }
}

