/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.cli;

import cdc.util.cli.OptionEnum;
import cdc.util.files.Files;
import cdc.util.lang.Checks;
import cdc.util.lang.ExceptionWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMainSupport<A, R> {
    private final Class<?> mainClass;
    private final Logger logger;
    private Result result = Result.SUCCESS;
    private boolean hasArgsFile = false;
    private int helpWidth = 74;
    private Path referencePath;
    public static final String DEFAULT_PARTS_SEPARATOR = "::";
    public static final String ARGS_FILE = "args-file";
    public static final String ARGS_FILE_CHARSET = "args-file-charset";
    public static final String CHARSET = "charset";
    public static final String DRIVER = "driver";
    public static final String HELP = "help";
    public static final String HELP_WIDTH = "help-width";
    public static final String INPUT = "input";
    public static final String INPUT_DIR = "input-dir";
    public static final String OUTPUT = "output";
    public static final String OUTPUT_DIR = "output-dir";
    public static final String PASSWORD = "password";
    public static final String PATH = "path";
    public static final String PREFIX = "prefix";
    public static final String TMP_DIR = "tmp-dir";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String VERSION = "version";
    public static final ValueChecker<Object> IS_TRUE = (cl, opt, object) -> object;
    public static final ValueChecker<File> IS_FILE = (cl, opt, file) -> {
        if (file == null || !file.isFile()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing file. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };
    public static final ValueChecker<File> IS_DIRECTORY = (cl, opt, file) -> {
        if (file == null || !file.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };
    public static final ValueChecker<File> IS_FILE_OR_DIRECTORY = (cl, opt, file) -> {
        if (file == null || !file.isFile() && !file.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing file or directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };
    public static final ValueChecker<File> IS_NULL_OR_FILE = (cl, opt, file) -> {
        if (file != null && !file.isFile()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing file. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };
    public static final ValueChecker<File> IS_NULL_OR_DIRECTORY = (cl, opt, file) -> {
        if (file != null && !file.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };
    public static final ValueChecker<File> IS_NULL_OR_FILE_OR_DIRECTORY = (cl, opt, file) -> {
        if (file != null && !file.isFile() && !file.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, file + " is not an existing file or directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    };

    protected AbstractMainSupport(Class<?> mainClass, Logger logger) {
        this.mainClass = mainClass;
        this.logger = logger;
    }

    protected boolean addArgsFileOption(Options options) {
        return AbstractMainSupport.hasMultipleValuesOption(options);
    }

    protected void addStandardOptions(Options options) {
        Option help = Option.builder((String)"h").longOpt(HELP).desc("Prints this help and exits.").build();
        options.addOption(help);
        options.addOption(Option.builder().longOpt(HELP_WIDTH).desc("Optional help width (default: 74).").hasArg().build());
        if (this.getVersion() != null) {
            Option version = Option.builder((String)"v").longOpt(VERSION).desc("Prints version and exits.").build();
            options.addOption(version);
            OptionGroup group = new OptionGroup();
            group.addOption(help);
            group.addOption(version);
            options.addOptionGroup(group);
        }
        if (this.addArgsFileOption(options)) {
            options.addOption(Option.builder().longOpt(ARGS_FILE).desc("Optional name of the file from which options can be read.\nA line is either ignored or interpreted as a single argument (option or value).\nA line is ignored when it is empty or starts by any number of white spaces followed by '#'.\nA line that only contains white spaces is an argument.\nA comment starts by a '#' not following a '\\'. The \"\\#\" sequence is read as '#'.").hasArg().build());
            options.addOption(Option.builder().longOpt(ARGS_FILE_CHARSET).desc("Optional name of the args file charset.\nIt may be used if args file encoding is not the OS default file encoding.").hasArg().build());
        }
    }

    public final Class<?> getMainClass() {
        return this.mainClass;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    protected String getVersion() {
        return null;
    }

    protected String getHelpHeader() {
        return null;
    }

    protected String getHelpFooter() {
        return null;
    }

    protected abstract void addSpecificOptions(Options var1);

    protected abstract A analyze(CommandLine var1) throws ParseException;

    protected abstract R execute(A var1) throws Exception;

    public static <E extends Enum<E>> void addNoArgOptions(Options options, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            options.addOption(Option.builder((String)((OptionEnum)((Object)e)).getShortName()).longOpt(((OptionEnum)((Object)e)).getName()).desc(((OptionEnum)((Object)e)).getDescription()).build());
        }
    }

    public static <E extends Enum<E>> void addGroupedNoArgOptions(Options options, Class<E> enumClass, boolean required) {
        AbstractMainSupport.addNoArgOptions(options, enumClass);
        AbstractMainSupport.createGroup((Options)options, (boolean)required, (Enum[])((Enum[])enumClass.getEnumConstants()));
    }

    public static OptionGroup createGroup(Options options, boolean required, String ... opts) {
        OptionGroup group = new OptionGroup();
        for (String opt : opts) {
            group.addOption(options.getOption(opt));
        }
        options.addOptionGroup(group);
        group.setRequired(required);
        return group;
    }

    public static OptionGroup createGroup(Options options, String ... opts) {
        return AbstractMainSupport.createGroup(options, false, opts);
    }

    public static OptionGroup createGroup(Options options, boolean required, Option ... opts) {
        OptionGroup group = new OptionGroup();
        for (Option opt : opts) {
            group.addOption(opt);
        }
        options.addOptionGroup(group);
        group.setRequired(required);
        return group;
    }

    public static OptionGroup createGroup(Options options, Option ... opts) {
        return AbstractMainSupport.createGroup(options, false, opts);
    }

    @SafeVarargs
    public static <E extends Enum<E>> OptionGroup createGroup(Options options, boolean required, E ... values) {
        OptionGroup group = new OptionGroup();
        for (E value : values) {
            group.addOption(options.getOption(((OptionEnum)value).getName()));
        }
        options.addOptionGroup(group);
        group.setRequired(required);
        return group;
    }

    @SafeVarargs
    public static <E extends Enum<E>> OptionGroup createGroup(Options options, E ... values) {
        return AbstractMainSupport.createGroup((Options)options, (boolean)false, values);
    }

    public static <E extends Enum<E>> void setMask(CommandLine cl, Class<E> enumClass, Maskable<E> maskable) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            maskable.setEnabled(e, cl.hasOption(((OptionEnum)((Object)e)).getName()));
        }
    }

    static String removeComments(String s) {
        int length = s.length();
        StringBuilder builder = new StringBuilder();
        boolean hasComments = false;
        for (int index = 0; index < length; ++index) {
            char c = s.charAt(index);
            if (c == '\\') {
                if (index < length - 1 && s.charAt(index + 1) == '#') {
                    builder.append('#');
                    ++index;
                    continue;
                }
                builder.append('\\');
                continue;
            }
            if (c == '#') {
                index = length;
                hasComments = true;
                continue;
            }
            builder.append(c);
        }
        String k = builder.toString();
        if (hasComments) {
            if (k.trim().isBlank()) {
                return "";
            }
            return k.stripTrailing();
        }
        return k;
    }

    private static String[] loadArgsFile(File file, String charsetName) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            String[] stringArray;
            try (BufferedReader reader = new BufferedReader(charsetName == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, charsetName));){
                ArrayList<String> list = new ArrayList<String>();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = AbstractMainSupport.removeComments(line)).isEmpty()) continue;
                    list.add(line);
                }
                stringArray = list.toArray(new String[list.size()]);
            }
            return stringArray;
        }
    }

    public R main(String[] args) {
        Options allOptions = this.buildOptions();
        Options optionalOptions = this.getOptionsAsOptional();
        DefaultParser parser = new DefaultParser();
        Exception x = null;
        try {
            CommandLine cl1;
            String[] effectiveArgs;
            CommandLine cl0 = parser.parse(optionalOptions, args);
            File argsFile = AbstractMainSupport.getValueAsFile(cl0, ARGS_FILE, IS_NULL_OR_FILE);
            String argsFileCharset = AbstractMainSupport.getValueAsString(cl0, ARGS_FILE_CHARSET, null);
            File currentDir = Files.currentDir();
            if (argsFile != null) {
                String[] fileArgs = AbstractMainSupport.loadArgsFile(argsFile, argsFileCharset);
                effectiveArgs = (String[])Stream.concat(Arrays.stream(fileArgs), Arrays.stream(args)).toArray(String[]::new);
                cl1 = parser.parse(optionalOptions, effectiveArgs);
                this.hasArgsFile = true;
                this.referencePath = currentDir.toPath().resolve(argsFile.toPath()).getParent();
            } else {
                effectiveArgs = args;
                cl1 = cl0;
                this.hasArgsFile = false;
                this.referencePath = currentDir.toPath();
            }
            this.helpWidth = AbstractMainSupport.getValueAsInt(cl1, HELP_WIDTH, 74);
            if (cl1.hasOption(HELP)) {
                this.printHelp(allOptions, null);
                return null;
            }
            if (cl1.hasOption(VERSION)) {
                this.printVersion();
                return null;
            }
            CommandLine cl2 = parser.parse(allOptions, effectiveArgs);
            A margs = this.analyze(cl2);
            try {
                return this.execute(margs);
            }
            catch (Exception e) {
                this.result = Result.EXECUTION_ERROR;
                this.getLogger().catching((Throwable)e);
                x = e;
            }
        }
        catch (Exception e) {
            this.result = Result.COMMAND_LINE_ERROR;
            this.printHelp(allOptions, e);
            x = e;
        }
        if (this.result == Result.EXECUTION_ERROR) {
            if (this.getExceptionThrowing().matchesExecution()) {
                throw ExceptionWrapper.wrap((Exception)x);
            }
            return null;
        }
        if (this.result == Result.COMMAND_LINE_ERROR) {
            if (this.getExceptionThrowing().matchesCommandLine()) {
                throw ExceptionWrapper.wrap((Exception)x);
            }
            return null;
        }
        return null;
    }

    protected final Result getResult() {
        return this.result;
    }

    public final boolean hasArgsFile() {
        return this.hasArgsFile;
    }

    public final Path getReferencePath() {
        return this.referencePath;
    }

    public File resolveToReferencePath(File file) {
        return this.referencePath.resolve(file.toPath()).toFile();
    }

    protected ExceptionThrowing getExceptionThrowing() {
        return ExceptionThrowing.EXECUTION;
    }

    private static boolean hasMultipleValuesOption(Options options) {
        for (Option option : options.getOptions()) {
            if (!option.hasArgs()) continue;
            return true;
        }
        return false;
    }

    protected Options buildOptions() {
        Options options = new Options();
        this.addSpecificOptions(options);
        this.addStandardOptions(options);
        return options;
    }

    protected Options getOptionsAsOptional() {
        Options options = new Options();
        for (Option option : this.buildOptions().getOptions()) {
            option.setRequired(false);
            options.addOption(option);
        }
        return options;
    }

    protected void printHelp(Options options, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("USAGE\n");
        formatter.setWidth(this.helpWidth);
        StringBuilder header = new StringBuilder();
        if (this.getHelpHeader() != null) {
            header.append("\n");
            header.append(this.getHelpHeader());
            header.append("\n");
        }
        header.append("\n");
        if (e != null && e.getMessage() != null) {
            header.append(e.getMessage());
            header.append("\n\n");
        }
        header.append("OPTIONS\n");
        formatter.printHelp(this.getMainClass().getSimpleName(), header.toString(), options, this.getHelpFooter(), true);
        if (e != null) {
            if (e instanceof ParseException) {
                if (this.getLogger().isEnabled(Level.DEBUG)) {
                    this.getLogger().catching((Throwable)e);
                }
            } else {
                this.getLogger().catching((Throwable)e);
            }
        }
    }

    protected void printVersion() {
        System.out.println(this.getVersion());
    }

    private static ParseException invalidArg(CommandLine cl, String opt, String message) {
        String[] values = cl.getOptionValues(opt);
        StringBuilder builder = new StringBuilder();
        if (values != null) {
            builder.append("Invalid args for ");
            builder.append(opt);
            builder.append(" args:");
            int count = Math.min(5, values.length);
            for (int index = 0; index < count; ++index) {
                builder.append(" '");
                builder.append(values[index]);
                builder.append('\'');
            }
            if (count < values.length) {
                builder.append(" ...");
            }
        } else {
            builder.append("Missing option ");
            builder.append(opt);
        }
        if (message != null) {
            builder.append(" ");
            builder.append(message);
        }
        return new ParseException(builder.toString());
    }

    public static <T> T getValue(CommandLine cl, String opt, T def, Function<String, T> converter, ValueChecker<? super T> checker) throws ParseException {
        if (cl.hasOption(opt)) {
            try {
                T result = converter.apply(cl.getOptionValue(opt));
                checker.check(cl, opt, result);
                return result;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw AbstractMainSupport.invalidArg(cl, opt, e.getMessage());
            }
        }
        checker.check(cl, opt, def);
        return def;
    }

    public static <T> T getValue(CommandLine cl, String opt, T def, Function<String, T> converter) throws ParseException {
        return (T)AbstractMainSupport.getValue(cl, opt, def, converter, IS_TRUE);
    }

    public static <T> void fillValues(CommandLine cl, String opt, Collection<T> values, Function<String, T> converter, ValueChecker<? super T> checker) throws ParseException {
        Checks.isNotNull(values, (String)"values");
        if (cl.hasOption(opt)) {
            try {
                for (String s : cl.getOptionValues(opt)) {
                    T v = converter.apply(s);
                    checker.check(cl, opt, v);
                    values.add(v);
                }
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw AbstractMainSupport.invalidArg(cl, opt, e.getMessage());
            }
        }
    }

    public static <T> void fillValues(CommandLine cl, String opt, Collection<T> values, Function<String, T> converter) throws ParseException {
        AbstractMainSupport.fillValues(cl, opt, values, converter, IS_TRUE);
    }

    public static <T> List<T> getValues(CommandLine cl, String opt, Function<String, T> converter, ValueChecker<? super T> checker) throws ParseException {
        ArrayList values = new ArrayList();
        AbstractMainSupport.fillValues(cl, opt, values, converter, checker);
        return values;
    }

    public static <T> List<T> getValues(CommandLine cl, String opt, Function<String, T> converter) throws ParseException {
        return AbstractMainSupport.getValues(cl, opt, converter, IS_TRUE);
    }

    public static void fillValues(CommandLine cl, String opt, Collection<String> values) {
        if (cl.hasOption(opt)) {
            Collections.addAll(values, cl.getOptionValues(opt));
        }
    }

    public static List<String> getValues(CommandLine cl, String opt) {
        ArrayList<String> values = new ArrayList<String>();
        if (cl.hasOption(opt)) {
            Collections.addAll(values, cl.getOptionValues(opt));
        }
        return values;
    }

    public File getValueAsResolvedFile(CommandLine cl, String opt, File def, ValueChecker<? super File> checker) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (file == null) {
            checker.check(cl, opt, null);
            return null;
        }
        File f = this.getReferencePath().resolve(file.toPath()).toFile();
        checker.check(cl, opt, f);
        return f;
    }

    public File getValueAsResolvedFile(CommandLine cl, String opt, ValueChecker<? super File> checker) throws ParseException {
        return this.getValueAsResolvedFile(cl, opt, null, checker);
    }

    public File getValueAsResolvedFile(CommandLine cl, String opt, File def) throws ParseException {
        return this.getValueAsResolvedFile(cl, opt, def, IS_TRUE);
    }

    public File getValueAsResolvedFile(CommandLine cl, String opt) throws ParseException {
        return this.getValueAsResolvedFile(cl, opt, null, IS_TRUE);
    }

    public static File getValueAsFile(CommandLine cl, String opt, File def, ValueChecker<? super File> checker) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, File::new, checker);
    }

    public static File getValueAsFile(CommandLine cl, String opt, ValueChecker<? super File> checker) throws ParseException {
        return AbstractMainSupport.getValueAsFile(cl, opt, null, checker);
    }

    public static File getValueAsFile(CommandLine cl, String opt, File def) throws ParseException {
        return AbstractMainSupport.getValueAsFile(cl, opt, def, IS_TRUE);
    }

    public static File getValueAsFile(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsFile(cl, opt, null, IS_TRUE);
    }

    public static File getOrCreateValueAsDirectory(CommandLine cl, String opt, File def) throws ParseException {
        boolean done;
        File result = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (result == null || result.exists() && !result.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not a directory. Current dir: '" + Files.currentDir() + "'");
        }
        if (!result.exists() && !(done = result.mkdirs())) {
            throw new ParseException("Failed to create directory: " + result);
        }
        return result;
    }

    public static File getOrCreateValueAsDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getOrCreateValueAsDirectory(cl, opt, null);
    }

    public static URL getValueAsURL(CommandLine cl, String opt, URL def) throws ParseException {
        if (cl.hasOption(opt)) {
            String s = cl.getOptionValue(opt);
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                throw new ParseException("Failed to convert '" + s + "' to URL (" + e.getMessage() + ")");
            }
        }
        return def;
    }

    public static URL getValueAsURL(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsURL(cl, opt, null);
    }

    public static Charset getValueAsCharset(CommandLine cl, String opt, Charset def) throws ParseException {
        if (cl.hasOption(opt)) {
            String s = cl.getOptionValue(opt);
            try {
                return Charset.forName(s);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new ParseException("Failed to convert '" + s + "' to Charset (" + e.getMessage() + ")");
            }
        }
        return def;
    }

    public static Charset getValueAsCharset(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsCharset(cl, opt, Charset.defaultCharset());
    }

    public static String getValueAsString(CommandLine cl, String opt, String def) {
        return cl.getOptionValue(opt, def);
    }

    private static char parseChar(String s) {
        if (s != null && s.length() == 1) {
            return s.charAt(0);
        }
        throw new IllegalArgumentException("Invalid char '" + s + "'");
    }

    public static char getValueAsChar(CommandLine cl, String opt, char def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, Character.valueOf(def), AbstractMainSupport::parseChar).charValue();
    }

    public static Character getValueAsChar(CommandLine cl, String opt, Character def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, AbstractMainSupport::parseChar);
    }

    public static long getValueAsLong(CommandLine cl, String opt, long def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Long::parseLong);
    }

    public static Long getValueAsLong(CommandLine cl, String opt, Long def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Long::parseLong);
    }

    public static int getValueAsInt(CommandLine cl, String opt, int def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Integer::parseInt);
    }

    public static Integer getValueAsInt(CommandLine cl, String opt, Integer def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Integer::parseInt);
    }

    public static short getValueAsShort(CommandLine cl, String opt, short def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Short::parseShort);
    }

    public static Short getValueAsShort(CommandLine cl, String opt, Short def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Short::parseShort);
    }

    public static byte getValueAsByte(CommandLine cl, String opt, byte def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Byte::parseByte);
    }

    public static Byte getValueAsByte(CommandLine cl, String opt, Byte def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Byte::parseByte);
    }

    public static double getValueAsDouble(CommandLine cl, String opt, double def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Double::parseDouble);
    }

    public static Double getValueAsDouble(CommandLine cl, String opt, Double def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Double::parseDouble);
    }

    public static float getValueAsFloat(CommandLine cl, String opt, float def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, Float.valueOf(def), Float::parseFloat).floatValue();
    }

    public static Float getValueAsFloat(CommandLine cl, String opt, Float def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Float::parseFloat);
    }

    public static <E extends Enum<E>> E getValueAsEnum(CommandLine cl, String opt, Class<E> enumClass, E def) throws ParseException {
        return (E)AbstractMainSupport.getValue(cl, opt, def, s -> {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equals(s)) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid enum value");
        });
    }

    public static int getNumberOfParts(String s, String sep) {
        int count = 0;
        int from = 0;
        while (from >= 0) {
            int pos = s.indexOf(sep, from);
            if (pos >= 0) {
                ++count;
                from = pos + sep.length();
                continue;
            }
            from = -1;
        }
        return count + 1;
    }

    public static String getPart(String s, String sep, int index, String def) {
        int count = 0;
        int from = 0;
        while (from >= 0) {
            int pos = s.indexOf(sep, from);
            if (pos >= 0) {
                if (count == index) {
                    return s.substring(from, pos);
                }
                ++count;
                from = pos + sep.length();
                continue;
            }
            if (count == index) {
                return s.substring(from);
            }
            from = -1;
        }
        return def;
    }

    public static String getPart(String s, String sep, int index) {
        return AbstractMainSupport.getPart(s, sep, index, null);
    }

    public static interface ValueChecker<T> {
        public T check(CommandLine var1, String var2, T var3) throws ParseException;
    }

    @FunctionalInterface
    public static interface Maskable<E extends Enum<E>> {
        public void setEnabled(E var1, boolean var2);
    }

    public static enum ExceptionThrowing {
        NEVER,
        EXECUTION,
        COMMAND_LINE_AND_EXECUTION;


        public boolean matchesExecution() {
            return this == EXECUTION || this == COMMAND_LINE_AND_EXECUTION;
        }

        public boolean matchesCommandLine() {
            return this == COMMAND_LINE_AND_EXECUTION;
        }
    }

    public static enum Result {
        COMMAND_LINE_ERROR,
        EXECUTION_ERROR,
        SUCCESS;

    }
}

