/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.cli;

import cdc.util.cli.OptionEnum;
import cdc.util.files.Files;
import cdc.util.lang.Checks;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMainSupport<A, R> {
    private final Class<?> mainClass;
    private final Logger logger;
    public static final String DEFAULT_PARTS_SEPARATOR = "::";
    public static final String ARGS_FILE = "args-file";
    public static final String CHARSET = "charset";
    public static final String DRIVER = "driver";
    public static final String HELP = "help";
    public static final String INPUT = "input";
    public static final String INPUT_DIR = "input-dir";
    public static final String OUTPUT = "output";
    public static final String OUTPUT_DIR = "output-dir";
    public static final String PASSWORD = "password";
    public static final String PATH = "path";
    public static final String PREFIX = "prefix";
    public static final String TMP_DIR = "tmp-dir";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String VERSION = "version";

    protected AbstractMainSupport(Class<?> mainClass, Logger logger) {
        this.mainClass = mainClass;
        this.logger = logger;
    }

    protected boolean addArgsFileOption(Options options) {
        return AbstractMainSupport.hasMultipleValuesOption(options);
    }

    protected void addStandardOptions(Options options) {
        Option help = Option.builder((String)"h").longOpt(HELP).desc("Prints this help and exits.").build();
        options.addOption(help);
        if (this.getVersion() != null) {
            Option version = Option.builder((String)"v").longOpt(VERSION).desc("Prints version and exits.").build();
            options.addOption(version);
            OptionGroup group = new OptionGroup();
            group.addOption(help);
            group.addOption(version);
            options.addOptionGroup(group);
        }
        if (this.addArgsFileOption(options)) {
            options.addOption(Option.builder().longOpt(ARGS_FILE).desc("Name of the file from which options can be read.\nA line is either ignored or interpreted as a single argument (option or value).\nA line is ignored when it is empty\u00a0or starts by any number of white spaces followed by '#'.\nA line that only contains white spaces is an argument.").hasArg().build());
        }
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected String getVersion() {
        return null;
    }

    protected String getHelpHeader() {
        return null;
    }

    protected String getHelpFooter() {
        return null;
    }

    protected abstract void addSpecificOptions(Options var1);

    protected abstract A analyze(CommandLine var1) throws ParseException;

    protected abstract R execute(A var1) throws Exception;

    public static <E extends Enum<E>> void addNoArgOptions(Options options, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            options.addOption(Option.builder((String)((OptionEnum)((Object)e)).getShortName()).longOpt(((OptionEnum)((Object)e)).getName()).desc(((OptionEnum)((Object)e)).getDescription()).build());
        }
    }

    public static <E extends Enum<E>> void addGroupedNoArgOptions(Options options, Class<E> enumClass, boolean required) {
        AbstractMainSupport.addNoArgOptions(options, enumClass);
        AbstractMainSupport.createGroup((Options)options, (boolean)required, (Enum[])((Enum[])enumClass.getEnumConstants()));
    }

    @SafeVarargs
    public static <E extends Enum<E>> OptionGroup createGroup(Options options, boolean required, E ... values) {
        OptionGroup group = new OptionGroup();
        for (E value : values) {
            group.addOption(options.getOption(((OptionEnum)value).getName()));
        }
        options.addOptionGroup(group);
        group.setRequired(required);
        return group;
    }

    @SafeVarargs
    public static <E extends Enum<E>> OptionGroup createGroup(Options options, E ... values) {
        return AbstractMainSupport.createGroup((Options)options, (boolean)false, values);
    }

    public static <E extends Enum<E>> void setMask(CommandLine cl, Class<E> enumClass, Maskable<E> maskable) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            maskable.setEnabled(e, cl.hasOption(((OptionEnum)((Object)e)).getName()));
        }
    }

    private static String removeComments(String s) {
        int pos = s.indexOf(35);
        if (pos < 0) {
            return s;
        }
        String k = s.substring(0, pos);
        if (k.trim().isEmpty()) {
            return "";
        }
        return k;
    }

    private static String[] loadArgs(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            String[] stringArray;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                ArrayList<String> list = new ArrayList<String>();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = AbstractMainSupport.removeComments(line)).isEmpty()) continue;
                    list.add(line);
                }
                stringArray = list.toArray(new String[list.size()]);
            }
            return stringArray;
        }
    }

    public R main(String[] args) {
        Options allOptions = this.buildOptions();
        Options optionalOptions = this.getOptionsAsOptional();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cl1;
            String[] effectiveArgs;
            CommandLine cl0 = parser.parse(optionalOptions, args);
            File argsFile = AbstractMainSupport.getValueAsNullOrExistingFile(cl0, ARGS_FILE, null);
            if (argsFile != null) {
                String[] fileArgs = AbstractMainSupport.loadArgs(argsFile);
                effectiveArgs = (String[])Stream.concat(Arrays.stream(fileArgs), Arrays.stream(args)).toArray(String[]::new);
                cl1 = parser.parse(optionalOptions, effectiveArgs);
            } else {
                effectiveArgs = args;
                cl1 = cl0;
            }
            if (cl1.hasOption(HELP)) {
                this.printHelp(allOptions, null);
                return null;
            }
            if (cl1.hasOption(VERSION)) {
                this.printVersion();
                return null;
            }
            CommandLine cl2 = parser.parse(allOptions, effectiveArgs);
            A margs = this.analyze(cl2);
            try {
                return this.execute(margs);
            }
            catch (Exception e) {
                this.logger.catching((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            this.printHelp(allOptions, e);
            return null;
        }
    }

    private static boolean hasMultipleValuesOption(Options options) {
        for (Option option : options.getOptions()) {
            if (!option.hasArgs()) continue;
            return true;
        }
        return false;
    }

    protected Options buildOptions() {
        Options options = new Options();
        this.addSpecificOptions(options);
        this.addStandardOptions(options);
        return options;
    }

    protected Options getOptionsAsOptional() {
        Options result = new Options();
        for (Option option : this.buildOptions().getOptions()) {
            option.setRequired(false);
            result.addOption(option);
        }
        return result;
    }

    protected void printHelp(Options options, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        StringBuilder header = new StringBuilder();
        if (this.getHelpHeader() != null) {
            header.append("\n");
            header.append(this.getHelpHeader());
        }
        header.append("\n");
        if (e != null && e.getMessage() != null) {
            header.append(e.getMessage());
            header.append("\n");
        }
        formatter.printHelp(this.mainClass.getSimpleName(), header.toString(), options, this.getHelpFooter(), true);
        if (e != null) {
            if (e instanceof ParseException) {
                if (this.logger.isEnabled(Level.DEBUG)) {
                    this.logger.catching((Throwable)e);
                }
            } else {
                this.logger.catching((Throwable)e);
            }
        }
    }

    protected void printVersion() {
        System.out.println(this.getVersion());
    }

    private static ParseException invalidArg(CommandLine cl, String opt, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid arg for ");
        builder.append(opt);
        builder.append(" args:");
        String[] values = cl.getOptionValues(opt);
        if (values != null) {
            int count = Math.min(5, values.length);
            for (int index = 0; index < count; ++index) {
                builder.append(" '");
                builder.append(values[index]);
                builder.append('\'');
            }
            if (count < values.length) {
                builder.append(" ...");
            }
        }
        if (message != null) {
            builder.append(" ");
            builder.append(message);
        }
        return new ParseException(builder.toString());
    }

    public static <T> T getValue(CommandLine cl, String opt, T def, Function<String, T> converter) throws ParseException {
        if (cl.hasOption(opt)) {
            try {
                return converter.apply(cl.getOptionValue(opt));
            }
            catch (Exception e) {
                throw AbstractMainSupport.invalidArg(cl, opt, e.getMessage());
            }
        }
        return def;
    }

    public static void fillValues(CommandLine cl, String opt, Collection<String> values) {
        if (cl.hasOption(opt)) {
            for (String s : cl.getOptionValues(opt)) {
                values.add(s);
            }
        }
    }

    public static <T> void fillValues(CommandLine cl, String opt, Collection<T> values, Function<String, T> converter) throws ParseException {
        Checks.isNotNull(values, (String)"values");
        if (cl.hasOption(opt)) {
            try {
                for (String s : cl.getOptionValues(opt)) {
                    values.add(converter.apply(s));
                }
            }
            catch (Exception e) {
                throw AbstractMainSupport.invalidArg(cl, opt, e.getMessage());
            }
        }
    }

    public static <T> List<T> getValues(CommandLine cl, String opt, Function<String, T> converter) throws ParseException {
        ArrayList values = new ArrayList();
        AbstractMainSupport.fillValues(cl, opt, values, converter);
        return values;
    }

    public static File getValueAsFile(CommandLine cl, String opt, File def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, File::new);
    }

    public static File getValueAsFile(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsFile(cl, opt, null);
    }

    public static File getValueAsExistingFile(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (file == null || !file.isFile()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing file. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsExistingFile(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsExistingFile(cl, opt, null);
    }

    public static File getValueAsDirectory(CommandLine cl, String opt, File def) throws ParseException {
        boolean done;
        File result = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (result == null || result.exists() && !result.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not a directory. Current dir: '" + Files.currentDir() + "'");
        }
        if (!result.exists() && !(done = result.mkdirs())) {
            throw new ParseException("Failed to create directory: " + result);
        }
        return result;
    }

    public static File getValueAsDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsDirectory(cl, opt, null);
    }

    public static File getValueAsNullOrExistingFile(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (!(file == null || file.exists() && file.isFile())) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing file. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsNullOrExistingFile(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsNullOrExistingFile(cl, opt, null);
    }

    public static File getValueAsExistingDirectory(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (file == null || !file.isDirectory()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsExistingDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsExistingDirectory(cl, opt, null);
    }

    public static File getValueAsNullOrExistingDirectory(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (!(file == null || file.exists() && file.isDirectory())) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsNullOrExistingDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsNullOrExistingDirectory(cl, opt, null);
    }

    public static File getValueAsExistingFileOrDirectory(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (file == null || !file.exists()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing file or directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsExistingFileOrDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsExistingFileOrDirectory(cl, opt, null);
    }

    public static File getValueAsNullOrExistingFileOrDirectory(CommandLine cl, String opt, File def) throws ParseException {
        File file = AbstractMainSupport.getValueAsFile(cl, opt, def);
        if (file != null && !file.exists()) {
            throw AbstractMainSupport.invalidArg(cl, opt, "is not an existing file or directory. Current dir: '" + Files.currentDir() + "'");
        }
        return file;
    }

    public static File getValueAsNullOrExistingFileOrDirectory(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsNullOrExistingFileOrDirectory(cl, opt, null);
    }

    public static URL getValueAsURL(CommandLine cl, String opt, URL def) throws ParseException {
        if (cl.hasOption(opt)) {
            String s = cl.getOptionValue(opt);
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                throw new ParseException("Failed to convert '" + s + "' to URL (" + e.getMessage() + ")");
            }
        }
        return def;
    }

    public static URL getValueAsURL(CommandLine cl, String opt) throws ParseException {
        return AbstractMainSupport.getValueAsURL(cl, opt, null);
    }

    public static String getValueAsString(CommandLine cl, String opt, String def) {
        return cl.getOptionValue(opt, def);
    }

    private static char parseChar(String s) {
        if (s != null && s.length() == 1) {
            return s.charAt(0);
        }
        throw new IllegalArgumentException("Invalid char '" + s + "'");
    }

    public static char getValueAsChar(CommandLine cl, String opt, char def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, Character.valueOf(def), AbstractMainSupport::parseChar).charValue();
    }

    public static Character getValueAsChar(CommandLine cl, String opt, Character def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, AbstractMainSupport::parseChar);
    }

    public static long getValueAsLong(CommandLine cl, String opt, long def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Long::parseLong);
    }

    public static Long getValueAsLong(CommandLine cl, String opt, Long def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Long::parseLong);
    }

    public static int getValueAsInt(CommandLine cl, String opt, int def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Integer::parseInt);
    }

    public static Integer getValueAsInt(CommandLine cl, String opt, Integer def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Integer::parseInt);
    }

    public static short getValueAsShort(CommandLine cl, String opt, short def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Short::parseShort);
    }

    public static Short getValueAsShort(CommandLine cl, String opt, Short def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Short::parseShort);
    }

    public static byte getValueAsByte(CommandLine cl, String opt, byte def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Byte::parseByte);
    }

    public static Byte getValueAsByte(CommandLine cl, String opt, Byte def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Byte::parseByte);
    }

    public static double getValueAsDouble(CommandLine cl, String opt, double def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Double::parseDouble);
    }

    public static Double getValueAsDouble(CommandLine cl, String opt, Double def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Double::parseDouble);
    }

    public static float getValueAsFloat(CommandLine cl, String opt, float def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, Float.valueOf(def), Float::parseFloat).floatValue();
    }

    public static Float getValueAsFloat(CommandLine cl, String opt, Float def) throws ParseException {
        return AbstractMainSupport.getValue(cl, opt, def, Float::parseFloat);
    }

    public static <E extends Enum<E>> E getValueAsEnum(CommandLine cl, String opt, Class<E> enumClass, E def) throws ParseException {
        return (E)AbstractMainSupport.getValue(cl, opt, def, s -> {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equals(s)) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid enum value");
        });
    }

    public static String getPart1(String s, String sep) {
        int pos = s.indexOf(sep);
        if (pos >= 0) {
            return s.substring(0, pos);
        }
        return s;
    }

    public static String getPart1(String s) {
        return AbstractMainSupport.getPart1(s, DEFAULT_PARTS_SEPARATOR);
    }

    public static String getPart2(String s, String sep, String def) {
        int pos = s.indexOf(sep);
        if (pos >= 0 && pos < s.length()) {
            return s.substring(pos + sep.length());
        }
        return def;
    }

    public static String getPart2(String s, String def) {
        return AbstractMainSupport.getPart2(s, DEFAULT_PARTS_SEPARATOR, def);
    }

    @FunctionalInterface
    public static interface Maskable<E extends Enum<E>> {
        public void setEnabled(E var1, boolean var2);
    }
}

