/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.cli;

import cdc.util.cli.OptionEnum;
import cdc.util.cli.OptionEnumType;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class OptionEnumMask {
    private final OptionEnumType type;
    private final Set<OptionEnum> options = new HashSet<OptionEnum>();

    public OptionEnumMask(OptionEnumType type) {
        this.type = type;
    }

    public final void setEnabled(OptionEnum option, boolean enabled) {
        Checks.isTrue((boolean)this.type.contains(option), (String)"Invalid option");
        if (enabled) {
            this.options.add(option);
        } else {
            this.options.remove(option);
        }
    }

    public final void add(OptionEnum option) {
        this.options.add(option);
    }

    public final void addAll(OptionEnum ... options) {
        for (OptionEnum feature : options) {
            this.add(feature);
        }
    }

    public final void addAll(Collection<? extends OptionEnum> options) {
        this.options.addAll(options);
    }

    public final void addAll(OptionEnumMask mask) {
        this.addAll(mask.options);
    }

    public final void remove(OptionEnum option) {
        this.options.remove(option);
    }

    public final boolean isEnabled(OptionEnum option) {
        return this.options.contains(option);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public final boolean contains(OptionEnum option) {
        return this.options.contains(option);
    }

    public final Set<OptionEnum> toSet() {
        return this.options.stream().collect(Collectors.toSet());
    }

    public final List<OptionEnum> toList() {
        return this.options.stream().toList();
    }

    public final boolean checkAtMostOne(Logger logger, FailureReaction reaction, OptionEnum ... options) {
        HashSet other = new HashSet();
        Collections.addAll(other, options);
        other.retainAll(this.options);
        if (other.size() <= 1) {
            return true;
        }
        FailureReaction.onError((String)("Expected at most one enabled feature among " + Arrays.toString(options)), (Logger)logger, (FailureReaction)reaction, IllegalArgumentException::new);
        return false;
    }

    public final boolean checkExactlyOne(Logger logger, FailureReaction reaction, OptionEnum ... options) {
        HashSet other = new HashSet();
        Collections.addAll(other, options);
        other.retainAll(this.options);
        if (other.size() == 1) {
            return true;
        }
        FailureReaction.onError((String)("Expected exactly one enabled feature among " + Arrays.toString(options)), (Logger)logger, (FailureReaction)reaction, IllegalArgumentException::new);
        return false;
    }
}

