/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.cli;

import cdc.util.cli.OptionEnum;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OptionEnumType {
    private final Map<String, Value> values = new HashMap<String, Value>();

    private Value add(Value value) {
        Checks.doesNotContainKey(this.values, (Object)value.getName(), (String)"values");
        this.values.put(value.getName(), value);
        return value;
    }

    public Collection<? extends OptionEnum> getValues() {
        return this.values.values();
    }

    public boolean contains(OptionEnum value) {
        return this.values.containsKey(value.getName()) && this.values.get(value.getName()) == value;
    }

    public Builder value() {
        return new Builder(this);
    }

    public Builder value(String name) {
        return this.value().name(name);
    }

    public Builder value(String name, String description) {
        return this.value().name(name).description(description);
    }

    private record Value(String name, String shortName, String description) implements OptionEnum
    {
        public Value {
            Checks.isNotNull((Object)name, (String)"name");
            Checks.isNotNull((Object)description, (String)"description");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static class Builder {
        private final OptionEnumType owner;
        private String name;
        private String shortName = null;
        private String description = "TODO";

        private Builder(OptionEnumType owner) {
            this.owner = owner;
        }

        public Builder init(OptionEnum other) {
            this.name = other.getName();
            this.shortName = other.getShortName();
            this.description = other.getDescription();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public OptionEnum build() {
            Value value = new Value(this.name, this.shortName, this.description);
            return this.owner.add(value);
        }
    }
}

