/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;

@JsonTypeName(value="coupaInstance")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CoupaInstance {
    private final String name;
    private final String apiUrl;
    private final String apiKey;

    @JsonCreator
    public CoupaInstance(@JsonProperty(value="name") String name, @JsonProperty(value="apiUrl") String apiUrl, @JsonProperty(value="apiKey") String apiKey) {
        Validate.notEmpty((CharSequence)name, (String)"name");
        Validate.notEmpty((CharSequence)apiUrl, (String)"apiUrl");
        this.name = name;
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoupaInstance that = (CoupaInstance)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.apiUrl != null ? !this.apiUrl.equals(that.apiUrl) : that.apiUrl != null) {
            return false;
        }
        return this.apiKey != null ? this.apiKey.equals(that.apiKey) : that.apiKey == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.apiUrl != null ? this.apiUrl.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

