/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.Validate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="execution")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduleExecution {
    public static final String URI = "/gdc/projects/{projectId}/schedules/{scheduleId}/executions/{executionId}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/schedules/{scheduleId}/executions/{executionId}");
    private static final Set<String> FINISHED_STATUSES = new HashSet<String>(Arrays.asList("OK", "ERROR", "CANCELED", "TIMEOUT"));
    private DateTime created;
    private String status;
    private String trigger;
    private String processLastDeployedBy;
    private Map<String, String> links;

    public ScheduleExecution() {
    }

    @JsonCreator
    private ScheduleExecution(@JsonProperty(value="createdTime") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime created, @JsonProperty(value="status") String executionStatus, @JsonProperty(value="trigger") String trigger, @JsonProperty(value="processLastDeployedBy") String processLastDeployedBy, @JsonProperty(value="links") Map<String, String> links) {
        this.created = created;
        this.status = executionStatus;
        this.trigger = trigger;
        this.processLastDeployedBy = processLastDeployedBy;
        this.links = links;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public String getProcessLastDeployedBy() {
        return this.processLastDeployedBy;
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get("self");
    }

    @JsonIgnore
    public boolean isFinished() {
        return FINISHED_STATUSES.contains(this.getStatus());
    }
}

