/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.sdk.model.executeafm.ObjQualifier;
import com.gooddata.sdk.model.executeafm.UriObjQualifier;
import com.gooddata.sdk.model.executeafm.afm.DerivedMeasureDefinition;
import com.gooddata.sdk.model.executeafm.afm.MeasureDefinition;
import com.gooddata.sdk.model.executeafm.afm.ObjIdentifierUtilities;
import com.gooddata.sdk.model.executeafm.afm.ObjQualifierConverter;
import com.gooddata.sdk.model.executeafm.afm.PreviousPeriodDateDataSet;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonRootName(value="previousPeriodMeasure")
public class PreviousPeriodMeasureDefinition
extends DerivedMeasureDefinition {
    private static final long serialVersionUID = -4741355657671354062L;
    static final String NAME = "previousPeriodMeasure";
    private final List<PreviousPeriodDateDataSet> dateDataSets;

    @JsonCreator
    public PreviousPeriodMeasureDefinition(@JsonProperty(value="measureIdentifier") String measureIdentifier, @JsonProperty(value="dateDataSets") List<PreviousPeriodDateDataSet> dateDataSets) {
        super(measureIdentifier);
        this.dateDataSets = (List)Validate.notEmpty(dateDataSets, (String)"dateDataSets");
    }

    @Override
    @Deprecated
    public ObjQualifier getObjQualifier() {
        throw new UnsupportedOperationException("The method is not supported by the object!");
    }

    @Override
    public Collection<ObjQualifier> getObjQualifiers() {
        return this.dateDataSets.stream().map(PreviousPeriodDateDataSet::getDataSet).collect(Collectors.toSet());
    }

    @Override
    @Deprecated
    public MeasureDefinition withObjUriQualifier(UriObjQualifier uriQualifier) {
        throw new UnsupportedOperationException("The method is not supported by the object!");
    }

    @Override
    public MeasureDefinition withObjUriQualifiers(ObjQualifierConverter objQualifierConverter) {
        Validate.notNull((Object)objQualifierConverter, (String)"objQualifierConverter");
        return new PreviousPeriodMeasureDefinition(this.measureIdentifier, this.copyDataSetsWithUriQualifiers(objQualifierConverter));
    }

    private List<PreviousPeriodDateDataSet> copyDataSetsWithUriQualifiers(ObjQualifierConverter objQualifierConverter) {
        return this.dateDataSets.stream().map(dataSet -> this.copyWithUriQualifier((PreviousPeriodDateDataSet)dataSet, objQualifierConverter)).collect(Collectors.toList());
    }

    private PreviousPeriodDateDataSet copyWithUriQualifier(PreviousPeriodDateDataSet dataSet, ObjQualifierConverter objQualifierConverter) {
        return ObjIdentifierUtilities.copyIfNecessary(dataSet, dataSet.getDataSet(), uriObjQualifier -> new PreviousPeriodDateDataSet((ObjQualifier)uriObjQualifier, dataSet.getPeriodsAgo()), objQualifierConverter);
    }

    @Override
    public boolean isAdHoc() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreviousPeriodMeasureDefinition that = (PreviousPeriodMeasureDefinition)o;
        return Objects.equals(this.dateDataSets, that.dateDataSets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateDataSets);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    public List<PreviousPeriodDateDataSet> getDateDataSets() {
        return this.dateDataSets;
    }
}

