/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.sdk.model.md.Obj;
import com.gooddata.sdk.model.util.TagsDeserializer;
import com.gooddata.sdk.model.util.TagsSerializer;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.BooleanIntegerSerializer;
import com.gooddata.util.BooleanStringSerializer;
import com.gooddata.util.GDDateTimeDeserializer;
import com.gooddata.util.GDDateTimeSerializer;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.Set;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Entry {
    private final String uri;
    private final String title;
    private final String summary;
    private final String category;
    private final String author;
    private final String contributor;
    private final Boolean deprecated;
    private final String identifier;
    private final Set<String> tags;
    private final DateTime created;
    private final DateTime updated;
    private final Boolean locked;
    private final Boolean unlisted;

    @JsonCreator
    public Entry(@JsonProperty(value="link") String uri, @JsonProperty(value="title") String title, @JsonProperty(value="summary") String summary, @JsonProperty(value="category") String category, @JsonProperty(value="author") String author, @JsonProperty(value="contributor") String contributor, @JsonProperty(value="deprecated") @JsonDeserialize(using=BooleanDeserializer.class) Boolean deprecated, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="tags") @JsonDeserialize(using=TagsDeserializer.class) Set<String> tags, @JsonProperty(value="created") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime created, @JsonProperty(value="updated") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime updated, @JsonProperty(value="locked") @JsonDeserialize(using=BooleanDeserializer.class) Boolean locked, @JsonProperty(value="unlisted") @JsonDeserialize(using=BooleanDeserializer.class) Boolean unlisted) {
        this.uri = uri;
        this.title = title;
        this.summary = summary;
        this.category = category;
        this.author = author;
        this.contributor = contributor;
        this.deprecated = deprecated;
        this.identifier = identifier;
        this.tags = tags;
        this.created = created;
        this.updated = updated;
        this.locked = locked;
        this.unlisted = unlisted;
    }

    @Deprecated
    public String getLink() {
        return this.getUri();
    }

    @JsonIgnore
    public String getId() {
        return (String)Obj.OBJ_TEMPLATE.match(this.getUri()).get("objId");
    }

    @JsonIgnore
    public String getUri() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContributor() {
        return this.contributor;
    }

    @JsonIgnore
    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    @JsonSerialize(using=BooleanStringSerializer.class)
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @JsonSerialize(using=TagsSerializer.class)
    public Set<String> getTags() {
        return this.tags;
    }

    @JsonSerialize(using=GDDateTimeSerializer.class)
    public DateTime getCreated() {
        return this.created;
    }

    @JsonSerialize(using=GDDateTimeSerializer.class)
    public DateTime getUpdated() {
        return this.updated;
    }

    @JsonIgnore
    public boolean isLocked() {
        return Boolean.TRUE.equals(this.locked);
    }

    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonIgnore
    public boolean isUnlisted() {
        return Boolean.TRUE.equals(this.unlisted);
    }

    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean getUnlisted() {
        return this.unlisted;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

