/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.sdk.model.md.dashboard.filter.FilterReference;
import com.gooddata.util.Validate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="kpi")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Kpi
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = -7747260758488157192L;
    private static final String NONE_COMPARISON_TYPE = "none";
    private final Content content;

    public Kpi(String title, String metricUri, String comparisonType, String comparisonDirection, List<FilterReference> ignoreDashboardFilters, String dateDatasetUri) {
        this(new Meta(title), new Content((String)Validate.notEmpty((CharSequence)metricUri, (String)"metricUri"), (String)Validate.notEmpty((CharSequence)comparisonType, (String)"comparisonType"), Kpi.checkDirection(comparisonType, comparisonDirection), null, dateDatasetUri, (List)Validate.notNull(ignoreDashboardFilters, (String)"ignoreDashboardFilters")));
    }

    private static String checkDirection(String comparisonType, String comparisonDirection) {
        if (NONE_COMPARISON_TYPE.equalsIgnoreCase((String)Validate.notEmpty((CharSequence)comparisonType, (String)"comparisonType"))) {
            return (String)Validate.notEmpty((CharSequence)comparisonDirection, (String)"comparisonDirection");
        }
        return comparisonDirection;
    }

    @JsonCreator
    private Kpi(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    @JsonIgnore
    public String getMetricUri() {
        return this.getContent().getMetric();
    }

    @JsonIgnore
    public String getComparisonType() {
        return this.getContent().getComparisonType();
    }

    @JsonIgnore
    public String getComparisonDirection() {
        return this.getContent().getComparisonDirection();
    }

    @JsonIgnore
    public String getDateDatasetUri() {
        String dateDatasetUri = this.getContent().getDateDataSet();
        return dateDatasetUri != null ? dateDatasetUri : this.getContent().getDateDimension();
    }

    @JsonIgnore
    public List<FilterReference> getIgnoreDashboardFilters() {
        return Collections.unmodifiableList(this.getContent().getIgnoreDashboardFilters());
    }

    @JsonProperty
    private Content getContent() {
        return this.content;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content
    implements Serializable {
        private final String metric;
        private final String comparisonType;
        private final String comparisonDirection;
        private final String dateDimension;
        private final String dateDataset;
        private final List<FilterReference> ignoreDashboardFilters;

        @JsonCreator
        private Content(@JsonProperty(value="metric") String metric, @JsonProperty(value="comparisonType") String comparisonType, @JsonProperty(value="comparisonDirection") String comparisonDirection, @JsonProperty(value="dateDimension") String dateDimension, @JsonProperty(value="dateDataSet") String dateDataset, @JsonProperty(value="ignoreDashboardFilters") List<FilterReference> ignoreDashboardFilters) {
            this.metric = metric;
            this.comparisonType = comparisonType;
            this.comparisonDirection = comparisonDirection;
            this.dateDimension = dateDimension;
            this.dateDataset = dateDataset;
            this.ignoreDashboardFilters = ignoreDashboardFilters;
        }

        public String getMetric() {
            return this.metric;
        }

        public String getComparisonType() {
            return this.comparisonType;
        }

        public String getComparisonDirection() {
            return this.comparisonDirection;
        }

        @Deprecated
        public String getDateDimension() {
            return this.dateDimension;
        }

        public String getDateDataSet() {
            return this.dateDataset;
        }

        public List<FilterReference> getIgnoreDashboardFilters() {
            return this.ignoreDashboardFilters;
        }
    }
}

