/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.model.executeafm.afm.AttributeItem;
import com.gooddata.sdk.model.executeafm.afm.LocallyIdentifiable;
import com.gooddata.sdk.model.executeafm.afm.MeasureItem;
import com.gooddata.sdk.model.executeafm.afm.NativeTotalItem;
import com.gooddata.sdk.model.executeafm.afm.filter.CompatibilityFilter;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Afm {
    private List<AttributeItem> attributes;
    private List<CompatibilityFilter> filters;
    private List<MeasureItem> measures;
    private List<NativeTotalItem> nativeTotals;

    @JsonCreator
    public Afm(@JsonProperty(value="attributes") List<AttributeItem> attributes, @JsonProperty(value="filters") List<CompatibilityFilter> filters, @JsonProperty(value="measures") List<MeasureItem> measures, @JsonProperty(value="nativeTotals") List<NativeTotalItem> nativeTotals) {
        this.attributes = attributes;
        this.filters = filters;
        this.measures = measures;
        this.nativeTotals = nativeTotals;
    }

    public Afm() {
    }

    @JsonIgnore
    public AttributeItem getAttribute(String localIdentifier) {
        return Afm.getIdentifiable(this.attributes, localIdentifier);
    }

    @JsonIgnore
    public MeasureItem getMeasure(String localIdentifier) {
        return Afm.getIdentifiable(this.measures, localIdentifier);
    }

    public List<AttributeItem> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeItem> attributes) {
        this.attributes = attributes;
    }

    public Afm addAttribute(AttributeItem attribute) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<AttributeItem>());
        }
        this.attributes.add((AttributeItem)Validate.notNull((Object)attribute, (String)"attribute"));
        return this;
    }

    public List<CompatibilityFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<CompatibilityFilter> filters) {
        this.filters = filters;
    }

    public Afm addFilter(CompatibilityFilter filter) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<CompatibilityFilter>());
        }
        this.filters.add((CompatibilityFilter)Validate.notNull((Object)filter, (String)"filter"));
        return this;
    }

    public List<MeasureItem> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<MeasureItem> measures) {
        this.measures = measures;
    }

    public Afm addMeasure(MeasureItem measure) {
        if (this.measures == null) {
            this.setMeasures(new ArrayList<MeasureItem>());
        }
        this.measures.add((MeasureItem)Validate.notNull((Object)measure, (String)"measure"));
        return this;
    }

    public List<NativeTotalItem> getNativeTotals() {
        return this.nativeTotals;
    }

    public void setNativeTotals(List<NativeTotalItem> nativeTotals) {
        this.nativeTotals = nativeTotals;
    }

    public Afm addNativeTotal(NativeTotalItem total) {
        if (this.nativeTotals == null) {
            this.setNativeTotals(new ArrayList<NativeTotalItem>());
        }
        this.nativeTotals.add((NativeTotalItem)Validate.notNull((Object)total, (String)"total"));
        return this;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    private static <T extends LocallyIdentifiable> T getIdentifiable(List<T> toSearch, String localIdentifier) {
        return (T)((LocallyIdentifiable)Optional.ofNullable(toSearch).flatMap(a -> a.stream().filter(i -> Objects.equals(localIdentifier, i.getLocalIdentifier())).findFirst()).orElseThrow(() -> new IllegalArgumentException(String.format("Item of localIdentifier=%s not found", localIdentifier))));
    }
}

