/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Expression;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.util.GoodDataToStringBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

@JsonTypeName(value="fact")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Fact
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = 1394960609414171940L;
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Fact(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    Fact(String title, String data, String type, String folder) {
        super(new Meta(title));
        this.content = new Content(Collections.singletonList(new Expression(data, type)), Collections.singletonList(folder));
    }

    @JsonIgnore
    public Collection<Expression> getExpressions() {
        return this.content.getExpression();
    }

    @JsonIgnore
    public Collection<String> getFolders() {
        return this.content.getFolders();
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 2141254685536566363L;
        @JsonProperty(value="expr")
        private final Collection<Expression> expression;
        @JsonProperty(value="folders")
        private final Collection<String> folders;

        @JsonCreator
        public Content(@JsonProperty(value="expr") Collection<Expression> expression, @JsonProperty(value="folders") Collection<String> folders) {
            this.expression = expression;
            this.folders = folders;
        }

        public Collection<Expression> getExpression() {
            return this.expression;
        }

        public Collection<String> getFolders() {
            return this.folders;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

