/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.dashboard.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.dashboard.filter.DashboardFilter;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Collections;
import java.util.List;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="attributeFilter")
@JsonIgnoreProperties(ignoreUnknown=true)
public class DashboardAttributeFilter
implements DashboardFilter {
    static final String NAME = "attributeFilter";
    private final String displayForm;
    private final boolean negativeSelection;
    private final List<String> attributeElements;

    @JsonCreator
    public DashboardAttributeFilter(@JsonProperty(value="displayForm") String displayForm, @JsonProperty(value="negativeSelection") boolean negativeSelection, @JsonProperty(value="attributeElements") List<String> attributeElementUris) {
        this.displayForm = (String)Validate.notEmpty((CharSequence)displayForm, (String)"displayForm");
        this.negativeSelection = negativeSelection;
        this.attributeElements = (List)Validate.notEmpty(attributeElementUris, (String)"attributeElementUris");
    }

    public String getDisplayForm() {
        return this.displayForm;
    }

    public boolean isNegativeSelection() {
        return this.negativeSelection;
    }

    @JsonIgnore
    public List<String> getAttributeElementUris() {
        return Collections.unmodifiableList(this.getAttributeElements());
    }

    @JsonProperty
    private List<String> getAttributeElements() {
        return this.attributeElements;
    }

    public String toString() {
        return GoodDataToStringBuilder.toString((Object)this);
    }
}

