/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.dataset.DatasetNotFoundException;
import com.gooddata.md.Meta;
import com.gooddata.util.Validate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="dataSetsInfo")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
class UploadsInfo {
    static final String URI = "/gdc/md/{projectId}/data/sets";
    static final UriTemplate URI_TEMPLATE = new UriTemplate("/gdc/md/{projectId}/data/sets");
    private final Map<String, DataSet> datasets = new HashMap<String, DataSet>();

    UploadsInfo(@JsonProperty(value="sets") Collection<DataSet> datasets) {
        if (datasets != null) {
            for (DataSet dataset : datasets) {
                this.datasets.put(dataset.getDatasetId(), dataset);
            }
        }
    }

    DataSet getDataSet(String datasetId) {
        Validate.notEmpty(datasetId, "datasetId");
        DataSet dataSet = this.datasets.get(datasetId);
        if (dataSet != null) {
            return dataSet;
        }
        throw new DatasetNotFoundException(datasetId);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="dataUploadShort")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    private static class LastUpload {
        private final String uri;

        private LastUpload(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class DataSet {
        private final Meta meta;
        private final String datasetUploadsUri;
        private final LastUpload lastUpload;

        private DataSet(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="dataUploads") String datasetUploadsUri, @JsonProperty(value="lastUpload") LastUpload lastUpload) {
            this.meta = meta;
            this.datasetUploadsUri = datasetUploadsUri;
            this.lastUpload = lastUpload;
        }

        String getDatasetId() {
            return this.meta.getIdentifier();
        }

        String getUploadsUri() {
            return this.datasetUploadsUri;
        }

        String getLastUploadUri() {
            return this.lastUpload.uri;
        }
    }
}

