/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.featureflag;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.featureflag.FeatureFlag;
import com.gooddata.util.Validate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="featureFlags")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureFlags
implements Iterable<FeatureFlag> {
    public static final String AGGREGATED_FEATURE_FLAGS_URI = "/gdc/internal/projects/{projectId}/featureFlags";
    public static final UriTemplate AGGREGATED_FEATURE_FLAGS_TEMPLATE = new UriTemplate("/gdc/internal/projects/{projectId}/featureFlags");
    private final List<FeatureFlag> featureFlags = new LinkedList<FeatureFlag>();

    @JsonAnySetter
    protected void addFlag(String name, boolean enabled) {
        Assert.notNull((Object)name);
        this.featureFlags.add(new FeatureFlag(name, enabled));
    }

    @Override
    public Iterator<FeatureFlag> iterator() {
        return this.featureFlags.iterator();
    }

    public boolean isEnabled(String flagName) {
        Validate.notEmpty(flagName, "flagName");
        for (FeatureFlag flag : this.featureFlags) {
            if (!flagName.equalsIgnoreCase(flag.getName())) continue;
            return flag.isEnabled();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlags that = (FeatureFlags)o;
        return !(this.featureFlags == null ? that.featureFlags != null : !this.featureFlags.equals(that.featureFlags));
    }

    public int hashCode() {
        return this.featureFlags != null ? this.featureFlags.hashCode() : 0;
    }

    public String toString() {
        return "FeatureFlags{" + this.featureFlags + "}";
    }
}

