/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Obj;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import com.gooddata.md.report.ReportDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@JsonTypeName(value="report")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Report
extends AbstractObj
implements Queryable,
Updatable {
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Report(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public Report(String title, ReportDefinition ... definitions) {
        this(new Meta(title), new Content(Arrays.asList(Report.uris((Obj[])definitions)), Collections.emptyList()));
    }

    @JsonIgnore
    public Collection<String> getDefinitions() {
        return this.content.getDefinitions();
    }

    @JsonIgnore
    public Collection<String> getDomains() {
        return this.content.getDomains();
    }

    private static class Content {
        private final Collection<String> definitions;
        private final Collection<String> domains;

        @JsonCreator
        public Content(@JsonProperty(value="definitions") Collection<String> definitions, @JsonProperty(value="domains") Collection<String> domains) {
            this.definitions = definitions;
            this.domains = domains;
        }

        public Collection<String> getDefinitions() {
            return this.definitions;
        }

        public Collection<String> getDomains() {
            return this.domains;
        }
    }
}

