/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

class DeprecationWarningRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.gooddata.sdk.DeprecationWarning");

    DeprecationWarningRequestInterceptor() {
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        List deprecated;
        ClientHttpResponse response = execution.execute(request, body);
        if (logger.isWarnEnabled() && (deprecated = response.getHeaders().get((Object)"X-GDC-DEPRECATED")) != null && !deprecated.isEmpty()) {
            List versionHeaders = request.getHeaders().get((Object)"X-GDC-Version");
            String version = versionHeaders != null && !versionHeaders.isEmpty() ? (String)versionHeaders.get(0) : "UNKNOWN";
            logger.warn("Resource path={} version={} deprecated {}", new Object[]{request.getURI().getPath(), version, deprecated.get(0)});
        }
        return response;
    }
}

