/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.util.GoodDataToStringBuilder;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

public class GoodDataSettings {
    private int maxConnections = 20;
    private int connectionTimeout = GoodDataSettings.secondsToMillis(10);
    private int connectionRequestTimeout = GoodDataSettings.secondsToMillis(10);
    private int socketTimeout = GoodDataSettings.secondsToMillis(60);
    private int pollSleep = GoodDataSettings.secondsToMillis(5);
    private String userAgent;

    public void setMaxConnections(int maxConnections) {
        Assert.isTrue((maxConnections > 0 ? 1 : 0) != 0, (String)"maxConnections must be greater than zero");
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"connectionTimeout must be not negative");
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionTimeoutSeconds(int connectionTimeout) {
        this.setConnectionTimeout(GoodDataSettings.secondsToMillis(connectionTimeout));
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        Assert.isTrue((connectionRequestTimeout >= 0 ? 1 : 0) != 0, (String)"connectionRequestTimeout must not be negative");
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionRequestTimeoutSeconds(int connectionRequestTimeout) {
        this.setConnectionRequestTimeout(GoodDataSettings.secondsToMillis(connectionRequestTimeout));
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        Assert.isTrue((socketTimeout >= 0 ? 1 : 0) != 0, (String)"socketTimeout must be not negative");
        this.socketTimeout = socketTimeout;
    }

    public void setSocketTimeoutSeconds(int socketTimeout) {
        this.setSocketTimeout(GoodDataSettings.secondsToMillis(socketTimeout));
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getPollSleep() {
        return this.pollSleep;
    }

    public void setPollSleep(int pollSleep) {
        Assert.isTrue((pollSleep >= 0 ? 1 : 0) != 0, (String)"pollSleep must be not negative");
        this.pollSleep = pollSleep;
    }

    public void setPollSleepSeconds(int pollSleep) {
        this.setPollSleep(GoodDataSettings.secondsToMillis(pollSleep));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoodDataSettings that = (GoodDataSettings)o;
        if (this.maxConnections != that.maxConnections) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.connectionRequestTimeout != that.connectionRequestTimeout) {
            return false;
        }
        if (this.socketTimeout != that.socketTimeout) {
            return false;
        }
        if (this.pollSleep != that.pollSleep) {
            return false;
        }
        return this.userAgent != null ? this.userAgent.equals(that.userAgent) : that.userAgent == null;
    }

    public int hashCode() {
        int result = this.maxConnections;
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.connectionRequestTimeout;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + this.pollSleep;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    private static int secondsToMillis(int seconds) {
        return (int)TimeUnit.SECONDS.toMillis(seconds);
    }
}

