/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.authentication;

import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.LoginSSTRetrievalStrategy;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.sdk.service.Authentication;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.util.Validate;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class LoginPasswordAuthentication
implements Authentication {
    private final String login;
    private final String password;

    public LoginPasswordAuthentication(String login, String password) {
        this.login = (String)Validate.notEmpty((CharSequence)login, (String)"login");
        this.password = (String)Validate.notEmpty((CharSequence)password, (String)"password");
    }

    @Override
    public HttpClient createHttpClient(GoodDataEndpoint endpoint, HttpClientBuilder builder) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)builder, (String)"builder");
        CloseableHttpClient httpClient = builder.build();
        LoginSSTRetrievalStrategy strategy = new LoginSSTRetrievalStrategy(this.login, this.password);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

