/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.authentication;

import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.SimpleSSTRetrievalStrategy;
import com.gooddata.sdk.service.Authentication;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.util.Validate;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SstAuthentication
implements Authentication {
    private final String sst;

    public SstAuthentication(String sst) {
        this.sst = (String)Validate.notEmpty((CharSequence)sst, (String)"sst");
    }

    @Override
    public HttpClient createHttpClient(GoodDataEndpoint endpoint, HttpClientBuilder builder) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)builder, (String)"builder");
        CloseableHttpClient httpClient = builder.build();
        SimpleSSTRetrievalStrategy strategy = new SimpleSSTRetrievalStrategy(this.sst);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

