/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.md;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.md.Attribute;
import com.gooddata.sdk.model.md.AttributeElement;
import com.gooddata.sdk.model.md.AttributeElements;
import com.gooddata.sdk.model.md.BulkGet;
import com.gooddata.sdk.model.md.BulkGetUris;
import com.gooddata.sdk.model.md.DisplayForm;
import com.gooddata.sdk.model.md.Entry;
import com.gooddata.sdk.model.md.IdentifierToUri;
import com.gooddata.sdk.model.md.IdentifiersAndUris;
import com.gooddata.sdk.model.md.InUseMany;
import com.gooddata.sdk.model.md.Obj;
import com.gooddata.sdk.model.md.Query;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Restriction;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.sdk.model.md.Usage;
import com.gooddata.sdk.model.md.UseMany;
import com.gooddata.sdk.model.md.report.ReportDefinition;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.md.NonUniqueObjException;
import com.gooddata.sdk.service.md.ObjCreateException;
import com.gooddata.sdk.service.md.ObjNotFoundException;
import com.gooddata.sdk.service.md.ObjUpdateException;
import com.gooddata.util.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class MetadataService
extends AbstractService {
    private static final Set<String> IRREGULAR_PLURAL_WORD_SUFFIXES = new HashSet<String>(Arrays.asList("s", "ch", "sh", "x", "o"));

    public MetadataService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public MetadataService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public <T extends Obj> T createObj(Project project, T obj) {
        Obj response;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull(obj, (String)"obj");
        try {
            response = (Obj)this.restTemplate.postForObject("/gdc/md/{projectId}/obj?createAndGet=true&setIdentifier=true", obj, obj.getClass(), new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ObjCreateException(obj, e);
        }
        if (response == null) {
            throw new ObjCreateException("Received empty response from API call.", obj);
        }
        return (T)response;
    }

    public <T extends Obj> T getObjByUri(String uri, Class<T> cls) {
        Validate.notNull((Object)uri, (String)"uri");
        Validate.notNull(cls, (String)"cls");
        try {
            Obj result = (Obj)this.restTemplate.getForObject(uri, cls, new Object[0]);
            if (result != null) {
                return (T)result;
            }
            throw new GoodDataException("Received empty response from API call.");
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ObjNotFoundException(uri, cls, (Exception)((Object)e));
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get " + cls.getSimpleName().toLowerCase() + " " + uri, (Throwable)e);
        }
    }

    public Collection<Obj> getObjsByUris(Project project, Collection<String> uris) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull(uris, (String)"uris");
        try {
            BulkGet result = (BulkGet)this.restTemplate.postForObject("/gdc/md/{projectId}/objects/get", (Object)new BulkGetUris(uris), BulkGet.class, new Object[]{project.getId()});
            if (result != null) {
                return result.getItems();
            }
            throw new GoodDataException("Received empty response from API call.");
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get objects. Some of the supplied URIs may be malformed.", (Throwable)e);
        }
    }

    public <T extends Updatable> T updateObj(T obj) {
        Validate.notNull(obj, (String)"obj");
        Validate.notNull((Object)obj.getUri(), (String)"obj.uri");
        try {
            this.restTemplate.put(obj.getUri(), obj, new Object[0]);
            return (T)((Updatable)this.getObjByUri(obj.getUri(), obj.getClass()));
        }
        catch (GoodDataException | RestClientException e) {
            throw new ObjUpdateException(obj, e);
        }
    }

    public void removeObj(Obj obj) {
        Validate.notNull((Object)obj, (String)"obj");
        Validate.notNull((Object)obj.getUri(), (String)"obj.uri");
        try {
            this.restTemplate.delete(obj.getUri(), new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ObjNotFoundException(obj);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to remove " + obj.getClass().getSimpleName().toLowerCase() + " " + obj.getUri(), (Throwable)e);
        }
    }

    public void removeObjByUri(String uri) {
        Validate.notNull((Object)uri, (String)"uri");
        try {
            this.restTemplate.delete(uri, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ObjNotFoundException(uri);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to remove " + uri, (Throwable)e);
        }
    }

    public <T extends Obj> T getObjById(Project project, String id, Class<T> cls) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)id, (String)"id");
        Validate.notNull(cls, (String)"cls");
        return this.getObjByUri(Obj.OBJ_TEMPLATE.expand(new Object[]{project.getId(), id}).toString(), cls);
    }

    public <T extends Queryable> String getObjUri(Project project, Class<T> cls, Restriction ... restrictions) {
        Collection<String> results = this.findUris(project, cls, restrictions);
        if (results == null || results.isEmpty()) {
            throw new ObjNotFoundException(cls);
        }
        if (results.size() != 1) {
            throw new NonUniqueObjException(cls, results);
        }
        return results.iterator().next();
    }

    public <T extends Queryable> T getObj(Project project, Class<T> cls, Restriction ... restrictions) {
        Collection<String> results = this.findUris(project, cls, restrictions);
        if (results == null || results.isEmpty()) {
            throw new ObjNotFoundException(cls);
        }
        if (results.size() != 1) {
            throw new NonUniqueObjException(cls, results);
        }
        return (T)((Queryable)this.getObjByUri(results.iterator().next(), cls));
    }

    public <T extends Queryable> Collection<Entry> find(Project project, Class<T> cls, Restriction ... restrictions) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull(cls, (String)"cls");
        String type = this.getQueryType(cls);
        try {
            Query queryResult = (Query)this.restTemplate.getForObject("/gdc/md/{projectId}/query/{type}", Query.class, new Object[]{project.getId(), type});
            if (queryResult != null && queryResult.getEntries() != null) {
                return this.filterEntries(queryResult.getEntries(), restrictions);
            }
            throw new GoodDataException("Received empty response from API call.");
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to query metadata: " + type, (Throwable)e);
        }
    }

    public <T extends Queryable> Collection<String> findUris(Project project, Class<T> cls, Restriction ... restrictions) {
        Collection<Entry> entries = this.find(project, cls, restrictions);
        ArrayList<String> result = new ArrayList<String>(entries.size());
        result.addAll(entries.stream().map(Entry::getUri).collect(Collectors.toList()));
        return result;
    }

    public Collection<Entry> usedBy(Project project, Obj obj, boolean nearest, Class<? extends Obj> ... types) {
        Validate.notNull((Object)obj, (String)"obj");
        return this.usedBy(project, obj.getUri(), nearest, types);
    }

    public Collection<Entry> usedBy(Project project, String uri, boolean nearest, Class<? extends Obj> ... types) {
        Validate.notNull((Object)uri, (String)"uri");
        Validate.notNull((Object)project, (String)"project");
        Collection<Usage> usages = this.usedBy(project, Arrays.asList(uri), nearest, types);
        return usages.size() > 0 ? usages.iterator().next().getUsedBy() : Collections.emptyList();
    }

    public Collection<Usage> usedBy(Project project, Collection<String> uris, boolean nearest, Class<? extends Obj> ... types) {
        UseMany response;
        Validate.notNull(uris, (String)"uris");
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            response = (UseMany)this.restTemplate.postForObject("/gdc/md/{projectId}/usedby2", (Object)new InUseMany(uris, nearest, (Class[])types), UseMany.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to find objects.", e);
        }
        ArrayList<Usage> usages = new ArrayList<Usage>(uris.size());
        Collection useManyEntries = response.getUseMany();
        usages.addAll(useManyEntries.stream().map(useMany -> new Usage(useMany.getUri(), useMany.getEntries())).collect(Collectors.toList()));
        return usages;
    }

    public Collection<String> findUris(Project project, Restriction ... restrictions) {
        Validate.notNull((Object)project, (String)"project");
        Validate.noNullElements((Object[])restrictions, (String)"restrictions");
        ArrayList<String> ids = new ArrayList<String>(restrictions.length);
        for (Restriction restriction : restrictions) {
            if (!Restriction.Type.IDENTIFIER.equals((Object)restriction.getType())) {
                throw new IllegalArgumentException("All restrictions have to be of type " + Restriction.Type.IDENTIFIER);
            }
            ids.add(restriction.getValue());
        }
        return this.getUrisForIdentifiers(project, ids).getUris();
    }

    public Map<String, String> identifiersToUris(Project project, Collection<String> identifiers) {
        Validate.notNull((Object)project, (String)"project");
        Validate.noNullElements(identifiers, (String)"identifiers");
        return this.getUrisForIdentifiers(project, identifiers).asMap();
    }

    public List<AttributeElement> getAttributeElements(Attribute attribute) {
        Validate.notNull((Object)attribute, (String)"attribute");
        return this.getAttributeElements(attribute.getDefaultDisplayForm());
    }

    public List<AttributeElement> getAttributeElements(DisplayForm displayForm) {
        Validate.notNull((Object)displayForm, (String)"displayForm");
        String elementsUri = displayForm.getElementsUri();
        if (StringUtils.isEmpty((Object)elementsUri)) {
            return Collections.emptyList();
        }
        try {
            AttributeElements attributeElements = (AttributeElements)this.restTemplate.getForObject(elementsUri, AttributeElements.class, new Object[0]);
            return attributeElements.getElements();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get attribute elements from " + elementsUri + ".", e);
        }
    }

    private Collection<Entry> filterEntries(Collection<Entry> entries, Restriction ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            return entries;
        }
        ArrayList<Entry> result = new ArrayList<Entry>(entries.size());
        for (Entry entry : entries) {
            block6: for (Restriction restriction : restrictions) {
                switch (restriction.getType()) {
                    case IDENTIFIER: {
                        if (!restriction.getValue().equals(entry.getIdentifier())) continue block6;
                        result.add(entry);
                        continue block6;
                    }
                    case TITLE: {
                        if (!restriction.getValue().equals(entry.getTitle())) continue block6;
                        result.add(entry);
                        continue block6;
                    }
                    case SUMMARY: {
                        if (!restriction.getValue().equals(entry.getSummary())) continue block6;
                        result.add(entry);
                    }
                }
            }
        }
        return result;
    }

    private IdentifiersAndUris getUrisForIdentifiers(Project project, Collection<String> identifiers) {
        IdentifiersAndUris response;
        try {
            response = (IdentifiersAndUris)this.restTemplate.postForObject("/gdc/md/{projectId}/identifiers", (Object)new IdentifierToUri(identifiers), IdentifiersAndUris.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get URIs from identifiers.", e);
        }
        return response;
    }

    private <T extends Queryable> String getQueryType(Class<T> cls) {
        String typeBase = cls.getSimpleName().toLowerCase();
        if (ReportDefinition.class.equals(cls)) {
            return typeBase;
        }
        if (IRREGULAR_PLURAL_WORD_SUFFIXES.stream().anyMatch(typeBase::endsWith)) {
            return typeBase + "es";
        }
        return typeBase + "s";
    }
}

