/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.project.model;

import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.gdc.AsyncTask;
import com.gooddata.sdk.model.gdc.TaskStatus;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.model.project.model.DiffRequest;
import com.gooddata.sdk.model.project.model.MaqlDdl;
import com.gooddata.sdk.model.project.model.MaqlDdlLinks;
import com.gooddata.sdk.model.project.model.ModelDiff;
import com.gooddata.sdk.service.AbstractPollHandlerBase;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.SimplePollHandler;
import com.gooddata.sdk.service.project.model.ModelException;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ModelService
extends AbstractService {
    public ModelService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public ModelService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    private FutureResult<ModelDiff> getProjectModelDiff(Project project, DiffRequest diffRequest) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)diffRequest, (String)"diffRequest");
        try {
            AsyncTask asyncTask = (AsyncTask)this.restTemplate.postForObject("/gdc/projects/{project-id}/model/diff", (Object)diffRequest, AsyncTask.class, new Object[]{project.getId()});
            return new PollResult<ModelDiff>(this, new SimplePollHandler<ModelDiff>(asyncTask.getUri(), ModelDiff.class){

                @Override
                public void handlePollException(GoodDataRestException e) {
                    throw new ModelException("Unable to get project model diff", e);
                }
            });
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ModelException("Unable to get project model diff", e);
        }
    }

    public FutureResult<ModelDiff> getProjectModelDiff(Project project, String targetModel) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)targetModel, (String)"targetModel");
        return this.getProjectModelDiff(project, new DiffRequest(targetModel));
    }

    public FutureResult<ModelDiff> getProjectModelDiff(Project project, Reader targetModel) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)targetModel, (String)"targetModel");
        try {
            return this.getProjectModelDiff(project, FileCopyUtils.copyToString((Reader)targetModel));
        }
        catch (IOException e) {
            throw new ModelException("Can't read target model", e);
        }
    }

    public FutureResult<Void> updateProjectModel(Project project, ModelDiff modelDiff) {
        Validate.notNull((Object)modelDiff, (String)"modelDiff");
        return this.updateProjectModel(project, modelDiff.getUpdateMaql());
    }

    public FutureResult<Void> updateProjectModel(Project project, ModelDiff.UpdateScript updateScript) {
        Validate.notNull((Object)updateScript, (String)"updateScript");
        return this.updateProjectModel(project, updateScript.getMaqlChunks());
    }

    public FutureResult<Void> updateProjectModel(Project project, String ... maqlDdl) {
        return this.updateProjectModel(project, Arrays.asList(maqlDdl));
    }

    public FutureResult<Void> updateProjectModel(final Project project, final Collection<String> maqlDdl) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.noNullElements(maqlDdl, (String)"maqlDdl");
        if (maqlDdl.isEmpty()) {
            throw new IllegalArgumentException("MAQL DDL string(s) should be given");
        }
        return new PollResult<Void>(this, new AbstractPollHandlerBase<MaqlDdlLinks, Void>(MaqlDdlLinks.class, Void.class){
            private final String projectId;
            private final LinkedList<String> maqlChunks;
            private String pollUri;
            {
                super(pollClass, resultClass);
                this.projectId = project.getId();
                this.maqlChunks = new LinkedList(maqlDdl);
                this.executeNextMaqlChunk();
            }

            private boolean executeNextMaqlChunk() {
                if (this.maqlChunks.isEmpty()) {
                    return true;
                }
                try {
                    MaqlDdlLinks links = (MaqlDdlLinks)ModelService.this.restTemplate.postForObject("/gdc/md/{project}/ldm/manage2", (Object)new MaqlDdl(this.maqlChunks.poll()), MaqlDdlLinks.class, new Object[]{this.projectId});
                    this.pollUri = links.getStatusUri();
                }
                catch (GoodDataRestException | RestClientException e) {
                    throw new ModelException("Unable to update project model", e);
                }
                return false;
            }

            @Override
            public String getPollingUri() {
                return this.pollUri;
            }

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                if (!super.isFinished(response)) {
                    return false;
                }
                TaskStatus maqlDdlTaskStatus = (TaskStatus)ModelService.this.extractData(response, TaskStatus.class);
                if (!maqlDdlTaskStatus.isSuccess()) {
                    throw new ModelException("Unable to update project model: " + maqlDdlTaskStatus.getMessages());
                }
                return this.executeNextMaqlChunk();
            }

            @Override
            public void handlePollResult(MaqlDdlLinks pollResult) {
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ModelException("Unable to update project model", e);
            }
        });
    }
}

