/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.executeafm;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.executeafm.Execution;
import com.gooddata.sdk.model.executeafm.ResultPage;
import com.gooddata.sdk.model.executeafm.VisualizationExecution;
import com.gooddata.sdk.model.executeafm.response.ExecutionResponse;
import com.gooddata.sdk.model.executeafm.result.ExecutionResult;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.SimplePollHandler;
import com.gooddata.sdk.service.executeafm.ExecutionResultException;
import com.gooddata.util.Validate;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ExecuteAfmService
extends AbstractService {
    public static final String AFM_EXECUTION_URI = "/gdc/app/projects/{projectId}/executeAfm";
    public static final String VISUALIZATION_EXECUTION_URI = "/gdc/app/projects/{projectId}/executeVisualization";
    public static final String RESULT_OFFSET = "offset";
    public static final String RESULT_LIMIT = "limit";

    public ExecuteAfmService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public ExecutionResponse executeAfm(Project project, Execution execution) {
        ExecutionResponse response;
        String projectId = (String)Validate.notNull((Object)((Project)Validate.notNull((Object)project, (String)"project")).getId(), (String)"projectId");
        try {
            response = (ExecutionResponse)this.restTemplate.postForObject(AFM_EXECUTION_URI, Validate.notNull((Object)execution, (String)"execution"), ExecutionResponse.class, new Object[]{projectId});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to execute AFM", e);
        }
        if (response == null) {
            throw new GoodDataException("Empty response when execution posted to API");
        }
        return response;
    }

    public ExecutionResponse executeVisualization(Project project, VisualizationExecution execution) {
        ExecutionResponse response;
        String projectId = (String)Validate.notNull((Object)((Project)Validate.notNull((Object)project, (String)"project")).getId(), (String)"projectId");
        try {
            response = (ExecutionResponse)this.restTemplate.postForObject(VISUALIZATION_EXECUTION_URI, Validate.notNull((Object)execution, (String)"execution"), ExecutionResponse.class, new Object[]{projectId});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to execute visualization", e);
        }
        if (response == null) {
            throw new GoodDataException("Empty response when execution posted to API");
        }
        return response;
    }

    public FutureResult<ExecutionResult> getResult(ExecutionResponse executionResponse) {
        return new PollResult<ExecutionResult>(this, new ExecutionPollHandler(((ExecutionResponse)Validate.notNull((Object)executionResponse, (String)"executionResponse")).getExecutionResultUri()));
    }

    public FutureResult<ExecutionResult> getResult(ExecutionResponse executionResponse, ResultPage page) {
        String executionResultUri = ((ExecutionResponse)Validate.notNull((Object)executionResponse, (String)"executionResponse")).getExecutionResultUri();
        String pagedResultUri = UriComponentsBuilder.fromUriString((String)executionResultUri).replaceQueryParam(RESULT_OFFSET, new Object[]{page.getOffsetsQueryParam()}).replaceQueryParam(RESULT_LIMIT, new Object[]{page.getLimitsQueryParam()}).build(true).toUriString();
        return new PollResult<ExecutionResult>(this, new ExecutionPollHandler(pagedResultUri));
    }

    private static final class ExecutionPollHandler
    extends SimplePollHandler<ExecutionResult> {
        ExecutionPollHandler(String pollingUri) {
            super(pollingUri, ExecutionResult.class);
        }

        @Override
        public void handlePollException(GoodDataRestException e) {
            throw new ExecutionResultException(e);
        }
    }
}

