/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.projecttemplate;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.dataset.DatasetManifest;
import com.gooddata.sdk.model.projecttemplate.Template;
import com.gooddata.sdk.model.projecttemplate.Templates;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.util.Validate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ProjectTemplateService
extends AbstractService {
    public ProjectTemplateService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public Collection<Template> getTemplates() {
        try {
            return ((Templates)this.restTemplate.getForObject("/projectTemplates", Templates.class, new Object[0])).getTemplates();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get templates", e);
        }
    }

    public Template getTemplateByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"template uri");
        try {
            return (Template)this.restTemplate.getForObject(uri, Template.class, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get template of uri=" + uri, e);
        }
    }

    public Collection<DatasetManifest> getManifests(Template template) {
        Validate.notNull((Object)template, (String)"template");
        Validate.notNull((Object)template.getManifestsUris(), (String)"template.manifestsUris");
        try {
            return template.getManifestsUris().stream().map(manifestUri -> (DatasetManifest)this.restTemplate.getForObject(manifestUri, DatasetManifest.class, new Object[0])).collect(Collectors.toList());
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get manifests for template of uri=" + template.getUri(), e);
        }
    }
}

