/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import java.util.Collections;
import java.util.List;

public class AndroidManifest {
    private final String applicationPackage;
    private final List<String> componentQualifiedNames;
    private final String applicationClassName;
    private final boolean libraryProject;

    public static AndroidManifest createManifest(String applicationPackage, String applicationClassName, List<String> componentQualifiedNames) {
        return new AndroidManifest(false, applicationPackage, applicationClassName, componentQualifiedNames);
    }

    public static AndroidManifest createLibraryManifest(String applicationPackage) {
        return new AndroidManifest(true, applicationPackage, "", Collections.<String>emptyList());
    }

    private AndroidManifest(boolean libraryProject, String applicationPackage, String applicationClassName, List<String> componentQualifiedNames) {
        this.libraryProject = libraryProject;
        this.applicationPackage = applicationPackage;
        this.applicationClassName = applicationClassName;
        this.componentQualifiedNames = componentQualifiedNames;
    }

    public String getApplicationPackage() {
        return this.applicationPackage;
    }

    public List<String> getComponentQualifiedNames() {
        return Collections.unmodifiableList(this.componentQualifiedNames);
    }

    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public boolean isLibraryProject() {
        return this.libraryProject;
    }
}

