/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaseHelper {
    private static final Pattern pattern = Pattern.compile("([A-Z]|[a-z])[a-z]*");

    public static String camelCaseToSnakeCase(String camelCase) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = pattern.matcher(camelCase);
        String acronym = "";
        while (matcher.find()) {
            String found = matcher.group();
            if (found.matches("^[A-Z]$")) {
                acronym = acronym + found;
                continue;
            }
            if (acronym.length() > 0) {
                tokens.add(acronym);
                acronym = "";
            }
            tokens.add(found.toLowerCase());
        }
        if (acronym.length() > 0) {
            tokens.add(acronym);
        }
        if (tokens.size() > 0) {
            StringBuilder sb = new StringBuilder((String)tokens.remove(0));
            for (String s : tokens) {
                sb.append("_").append(s);
            }
            return sb.toString();
        }
        return camelCase;
    }
}

