/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation.rest;

import com.googlecode.androidannotations.annotations.rest.Rest;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class RestValidator
implements ElementValidator {
    private final ValidatorHelper validatorHelper;

    public RestValidator(ProcessingEnvironment processingEnv) {
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Rest.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.notAlreadyValidated(element, validatedElements, valid);
        this.validatorHelper.hasSpringAndroidJars(element, valid);
        this.validatorHelper.isInterface(typeElement, valid);
        this.validatorHelper.isTopLevel(typeElement, valid);
        this.validatorHelper.doesNotExtendOtherInterfaces(typeElement, valid);
        this.validatorHelper.unannotatedMethodReturnsRestTemplate(typeElement, valid);
        this.validatorHelper.validateConverters(element, valid);
        return valid.isValid();
    }
}

