/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Click;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ClickProcessor
implements DecoratingElementProcessor {
    private final AnnotationHelper helper;
    private final IRClass rClass;

    public ClickProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.rClass = rClass;
        this.helper = new AnnotationHelper(processingEnv);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Click.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean hasViewParameter = parameters.size() == 1;
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, this.getTarget(), this.rClass.get(IRClass.Res.ID), true);
        JDefinedClass onClickListenerClass = codeModel.anonymousClass(classes.VIEW_ON_CLICK_LISTENER);
        JMethod onClickMethod = onClickListenerClass.method(1, codeModel.VOID, "onClick");
        onClickMethod.annotate(Override.class);
        JVar onClickViewParam = onClickMethod.param(classes.VIEW, "view");
        JFieldRef activityRef = holder.generatedClass.staticRef("this");
        JInvocation clickCall = onClickMethod.body().invoke((JExpression)activityRef, methodName);
        if (hasViewParameter) {
            clickCall.arg(onClickViewParam);
        }
        for (JFieldRef idRef : idsRefs) {
            JBlock block = holder.afterSetContentView.body().block();
            JInvocation findViewById = JExpr.invoke("findViewById");
            JVar view = block.decl(classes.VIEW, "view", findViewById.arg(idRef));
            block._if(view.ne(JExpr._null()))._then().invoke((JExpression)view, "setOnClickListener").arg(JExpr._new(onClickListenerClass));
        }
    }
}

