/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Transactional;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class TransactionalProcessor
implements DecoratingElementProcessor {
    private final APTCodeModelHelper helper = new APTCodeModelHelper();

    @Override
    public Class<? extends Annotation> getTarget() {
        return Transactional.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        String returnTypeName = ((Object)executableElement.getReturnType()).toString();
        JClass returnType = holder.refClass(returnTypeName);
        JMethod method = this.helper.overrideAnnotatedMethod(executableElement, holder);
        this.helper.removeBody(method);
        JVar db = method.params().get(0);
        JBlock body = method.body();
        body.invoke((JExpression)db, "beginTransaction");
        JTryBlock tryBlock = body._try();
        JFieldRef activitySuper = holder.generatedClass.staticRef("super");
        JInvocation superCall = JExpr.invoke((JExpression)activitySuper, method);
        for (JVar param : method.params()) {
            superCall.arg(param);
        }
        JBlock tryBody = tryBlock.body();
        if (returnTypeName.equals("void")) {
            tryBody.add(superCall);
            tryBody.invoke((JExpression)db, "setTransactionSuccessful");
            tryBody._return();
        } else {
            JVar result = tryBody.decl(returnType, "result_", superCall);
            tryBody.invoke((JExpression)db, "setTransactionSuccessful");
            tryBody._return(result);
        }
        JCatchBlock catchBlock = tryBlock._catch(holder.refClass(RuntimeException.class));
        JVar exceptionParam = catchBlock.param("e");
        JBlock catchBody = catchBlock.body();
        JInvocation errorInvoke = catchBody.staticInvoke(holder.classes().LOG, "e");
        errorInvoke.arg(holder.generatedClass.name());
        errorInvoke.arg("Error in transaction");
        errorInvoke.arg(exceptionParam);
        catchBody._throw(exceptionParam);
        tryBlock._finally().invoke((JExpression)db, "endTransaction");
    }
}

