package com.googlecode.gendevcode.ant;

import java.util.HashMap;
import java.util.Map;

/**
 * Ant常量
 * @author devilishking
 *
 */
public class AntConstants {
	/**
	 * 生成级别：model
	 */
	public static String GENLEVEL_MODEL = "model";
	/**
	 * 生成级别：dao
	 */
	public static String GENLEVEL_DAO = "dao";
	/**
	 * 生成级别：dao.impl
	 */
	public static String GENLEVEL_DAOIMPL = "dao.impl";
	/**
	 * 生成级别：service
	 */
	public static String GENLEVEL_SERVICE = "service";
	/**
	 * 生成级别：service.impl
	 */
	public static String GENLEVEL_SERVICEIMPL = "service.impl";
	/**
	 * 生成级别：web.action
	 */
	public static String GENLEVEL_WEBACTION = "web.action";
	/**
	 * 生成级别：web.form
	 */
	public static String GENLEVEL_WEBFORM = "web.form";
	/**
	 * 生成级别对应源码根目录
	 */
	public static Map<String, String> GENLEVEL_SRCPATH_MAP;
	/**
	 * dao层源码根目录
	 */
	public static String BASE_SRC_DAO_PATH = "src/dao";
	/**
	 * service层源码根目录
	 */
	public static String BASE_SRC_SERVICE_PATH = "src/service";
	/**
	 * web层源码根目录
	 */
	public static String BASE_SRC_WEB_PATH = "src/web";
	/**
	 * 页面根目录
	 */
	public static String BASE_PAGEPATH = "web/pages";
	
	static{		
		GENLEVEL_SRCPATH_MAP = new HashMap<String, String>();
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_MODEL, BASE_SRC_DAO_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_DAO, BASE_SRC_DAO_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_DAOIMPL, BASE_SRC_DAO_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_SERVICE, BASE_SRC_SERVICE_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_SERVICEIMPL, BASE_SRC_SERVICE_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_WEBACTION, BASE_SRC_WEB_PATH);
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_WEBFORM, BASE_SRC_WEB_PATH);
	}
}