package com.googlecode.gendevcode.ant.service;

import java.util.ArrayList;
import java.util.List;

import com.googlecode.gendevcode.ant.AntConstants;
import com.googlecode.gendevcode.model.ProjectXml;
import com.googlecode.gendevcode.service.basic.ProjectConfigServiceSupport;

/**
 * 项目设置实现类(Ant)
 * @author devilishking
 *
 */
public class AntProjectConfigServiceImpl extends ProjectConfigServiceSupport<AntProjectConfigServiceImpl> {	
	/**
	 * 获取生成级别列表
	 * @return
	 * @throws Exception
	 */
	public List<String> getGenLevelList() throws Exception {
		List<String> dataList = new ArrayList<String>();
		dataList.add(AntConstants.GENLEVEL_MODEL);
		dataList.add(AntConstants.GENLEVEL_DAO);
		dataList.add(AntConstants.GENLEVEL_DAOIMPL);
		dataList.add(AntConstants.GENLEVEL_SERVICE);
		dataList.add(AntConstants.GENLEVEL_SERVICEIMPL);
		dataList.add(AntConstants.GENLEVEL_WEBACTION);
		dataList.add(AntConstants.GENLEVEL_WEBFORM);
		return dataList;
	}

	/**
	 * 根据模块名称和生成级别获取待生成的文件路径
	 * @param packageCode 包名
	 * @param genLevel    生成级别
	 * @param projectXml  项目信息
	 * @return
	 * @throws Exception
	 */
	public String getGenFilePath(String packageCode, String genLevel, ProjectXml projectXml) throws Exception{
		StringBuilder filePath = (new StringBuilder()).append(projectXml.getProjectPath());
		
		String packageCodePath = packageCode.replace(".", "/");
		filePath.append(AntConstants.GENLEVEL_SRCPATH_MAP.get(genLevel))
				.append("/")
				.append(packageCodePath);
		if (AntConstants.GENLEVEL_DAO.equals(genLevel)){
			filePath.append("/dao");
		}
		else if (AntConstants.GENLEVEL_DAOIMPL.equals(genLevel)){
			filePath.append("/dao/impl");
		}
		else if (AntConstants.GENLEVEL_MODEL.equals(genLevel)){
			filePath.append("/model");
		}
		else if (AntConstants.GENLEVEL_SERVICE.equals(genLevel)){
			filePath.append("/service");
		}
		else if (AntConstants.GENLEVEL_SERVICEIMPL.equals(genLevel)){
			filePath.append("/service/impl");
		}
		else if (AntConstants.GENLEVEL_WEBACTION.equals(genLevel)){
			filePath.append("/web/action");
		}
		else if (AntConstants.GENLEVEL_WEBFORM.equals(genLevel)){
			filePath.append("/web/form");
		}
		
		return filePath.toString();
	}
}