package com.googlecode.gendevcode.common;

import java.io.File;
import java.io.PrintWriter;

/**
 * 通用辅助类
 * @author devilishking
 *
 */
public class Util {	
	/**
	 * 将字符串写入文件中
	 * @param text	        字符串
	 * @param filePath 文件全路径
	 * @throws Exception
	 */
	public static void writeFile(String text, String filePath) throws Exception{
		File file = new File(filePath); 
		if (!file.getParentFile().exists()){
			file.mkdirs();
		}
		PrintWriter out = null;
		try{
			out = new PrintWriter(file, "UTF-8");   
	    	out.print(text);
		}
		finally{
	    	if (out != null) out.close();
		}
	}
}