package com.googlecode.gendevcode.maven;

import java.util.HashMap;
import java.util.Map;

/**
 * Maven常量
 * @author devilishking
 *
 */
public class MvnConstants {
	/**
	 * 生成级别：model
	 */
	public static String GENLEVEL_MODEL = "model";
	/**
	 * 生成级别：dao
	 */
	public static String GENLEVEL_DAO = "dao";
	/**
	 * 生成级别：dao.impl
	 */
	public static String GENLEVEL_DAOIMPL = "dao.impl";
	/**
	 * 生成级别：service
	 */
	public static String GENLEVEL_SERVICE = "service";
	/**
	 * 生成级别：service.impl
	 */
	public static String GENLEVEL_SERVICEIMPL = "service.impl";
	/**
	 * 生成级别：web.controller
	 */
	public static String GENLEVEL_WEBCONTROLLER = "web.controller";
	/**
	 * 生成级别：pages
	 */
	public static String GENLEVEL_PAGES = "pages";
	/**
	 * 生成级别：column.xml
	 */
	public static String GENLEVEL_COLUMN = "column.xml";
	/**
	 * 生成级别对应源码根目录
	 */
	public static Map<String, String> GENLEVEL_SRCPATH_MAP;
	/**
	 * 源码根目录
	 */
	public static String BASE_SRCPATH = "src/main/java";
	/**
	 * 页面根目录
	 */
	public static String BASE_PAGEPATH = "src/main/webapp/pages";
	
	static {		
		GENLEVEL_SRCPATH_MAP = new HashMap<String, String>();
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_MODEL, "model");
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_DAO, "dao");
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_DAOIMPL, "dao/impl");
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_SERVICE, "service");
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_SERVICEIMPL, "service/impl");
		GENLEVEL_SRCPATH_MAP.put(GENLEVEL_WEBCONTROLLER, "web/controller");
	}
}