package com.googlecode.gendevcode.maven.service;

import java.util.ArrayList;
import java.util.List;

import com.googlecode.gendevcode.maven.MvnConstants;
import com.googlecode.gendevcode.model.ProjectXml;
import com.googlecode.gendevcode.service.basic.ProjectConfigServiceSupport;

/**
 * 项目设置实现类(Maven)
 * @author devilishking
 *
 */
public class MvnProjectConfigServiceImpl extends ProjectConfigServiceSupport<MvnProjectConfigServiceImpl>{	
	/**
	 * 获取生成级别列表
	 * @return
	 * @throws Exception
	 */
	public List<String> getGenLevelList() throws Exception{
		List<String> dataList = new ArrayList<String>();
		dataList.add(MvnConstants.GENLEVEL_MODEL);
		dataList.add(MvnConstants.GENLEVEL_DAO);
		dataList.add(MvnConstants.GENLEVEL_DAOIMPL);
		dataList.add(MvnConstants.GENLEVEL_SERVICE);
		dataList.add(MvnConstants.GENLEVEL_SERVICEIMPL);
		dataList.add(MvnConstants.GENLEVEL_WEBCONTROLLER);
		dataList.add(MvnConstants.GENLEVEL_PAGES);
		dataList.add(MvnConstants.GENLEVEL_COLUMN);
		return dataList;
	}

	/**
	 * 根据模块名称和生成级别获取待生成的文件路径
	 * @param packageCode 包名
	 * @param genLevel    生成级别
	 * @param projectXml  项目信息
	 * @return
	 * @throws Exception
	 */
	public String getGenFilePath(String packageCode, String genLevel, ProjectXml projectXml) throws Exception{
		StringBuilder filePath = (new StringBuilder()).append(projectXml.getProjectPath());
		
		String[] packageCodeArr = packageCode.split("\\.");
		String module = packageCodeArr[packageCodeArr.length-1];
		filePath.append("/").append(projectXml.getName()).append("-");
		StringBuilder baseClassPath = (new StringBuilder()).append(projectXml.getGroupId().replace(".", "/"));
		
//		if (MvnConstants.GENLEVEL_WEBCONTROLLER.equals(genLevel)){
//			filePath.append("web").append("/").append(MvnConstants.BASE_SRCPATH)
//					.append("/").append(baseClassPath).append("/")
//					.append("/").append(MvnConstants.GENLEVEL_SRCPATH_MAP.get(genLevel))
//					.append("/").append(module);
//		}
//		else{
//		}
		filePath.append(module).append("/").append(MvnConstants.BASE_SRCPATH)
				.append("/").append(baseClassPath).append("/").append(module)
				.append("/").append(MvnConstants.GENLEVEL_SRCPATH_MAP.get(genLevel));
		
		return filePath.toString();
	}
}