package com.googlecode.gendevcode.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.googlecode.gendevcode.common.Cache;
import com.googlecode.gendevcode.model.basic.XmlObject;

/**
 * 项目信息
 * @author devilishking
 *
 */
public class ProjectXml extends XmlObject<ProjectXml> {
	private static final long serialVersionUID = 1L;

	private String id;							 //编号
	private String userName;					 //用户名称
	private String groupId;						 //组织名
	private Boolean isCustomSys;				 //是否使用自定义系统管理模块
	private String cnName;						 //项目名(中文名)
	private String name;						 //项目名(英文名)
	private Integer type;						 //项目类型
	private String projectPath;					 //项目根目录
	private String pdmPath;						 //PDM路径
	private String resourcesPath;				 //资源路径
	private String[] modules;	 				 //模块组
	
	/**
	 * 对象名
	 */
	public static final String OBJECT_NAME = (new StringBuffer()).append(ProjectXml.class.getSimpleName().substring(0, 1).toLowerCase())
																 .append(ProjectXml.class.getSimpleName().substring(1))
																 .toString();
	
	//region 标签
	/**
	 * 标签：系统配置的表名
	 */
	public static final String TAG_SYSCONFIG_TABLE = "SYSCONFIG";
	/**
	 * 标签：项目的表名
	 */
	public static final String TAG_PROJECT_TABLE = "PROJECT";
	/**
	 * 标签：编号
	 */
	public static final String TAG_ID = "ID";
	/**
	 * 标签：用户名称
	 */
	public static final String TAG_USERNAME = "USERNAME";
	/**
	 * 标签：组织名
	 */
	public static final String TAG_GROUPID = "GROUPID";
	/**
	 * 标签：是否使用自定义系统管理模块
	 */
	public static final String TAG_ISCUSTOMSYS = "ISCUSTOMSYS";
	/**
	 * 标签：项目名(中文名)
	 */
	public static final String TAG_CNNAME = "CNNAME";
	/**
	 * 标签：项目名(英文名)
	 */
	public static final String TAG_NAME = "NAME";
	/**
	 * 标签：项目类型
	 */
	public static final String TAG_TYPE = "TYPE";
	/**
	 * 标签：项目根目录
	 */
	public static final String TAG_PROJECTPATH = "PROJECTPATH";
	/**
	 * 标签：PDM路径
	 */
	public static final String TAG_PDMPATH = "PDMPATH";
	/**
	 * 标签：资源路径
	 */
	public static final String TAG_RESOURCESPATH = "RESOURCESPATH";
	/**
	 * 标签：模块名称组
	 */
	public static final String TAG_MODULES = "MODULES";
	//endregion
	
	//region 字典
	/**
	 * 项目类型：ant
	 */
	public static final int TYPE_ANT = 0;
	/**
	 * 项目类型：maven
	 */
	public static final int TYPE_MAVEN = 0;
	//endregion

	//region 属性GET、SET方法
	/**
	 * 获取编号
	 */
	public String getId() {
		return id;
	}
	/**
	 * 设置编号
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * 获取用户名称
	 */
	public String getUserName() {
		return userName;
	}
	/**
	 * 设置用户名称
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}
	/**
	 * 获取组织名
	 */
	public String getGroupId() {
		return groupId;
	}
	/**
	 * 设置是否使用自定义系统管理模块
	 */
	public Boolean getIsCustomSys() {
		return isCustomSys;
	}
	/**
	 * 获取是否使用自定义系统管理模块
	 */
	public void setIsCustomSys(Boolean isCustomSys) {
		this.isCustomSys = isCustomSys;
	}
	/**
	 * 设置组织名
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}
	/**
	 * 获取项目名(中文名)
	 */
	public String getCnName() {
		return cnName;
	}
	/**
	 * 设置项目名(中文名)
	 */
	public void setCnName(String cnName) {
		this.cnName = cnName;
	}
	/**
	 * 获取项目名(英文名)
	 */
	public String getName() {
		return name;
	}
	/**
	 * 设置项目名(英文名)
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * 获取项目类型
	 */
	public Integer getType() {
		return type;
	}
	/**
	 * 设置项目类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	/**
	 * 获取项目根目录
	 */
	public String getProjectPath() {
		return projectPath;
	}
	/**
	 * 设置项目根目录
	 * @param projectPath
	 */
	public void setProjectPath(String projectPath) {
		this.projectPath = projectPath;
	}
	/**
	 * 获取PDM路径
	 */
	public String getPdmPath() {
		return pdmPath;
	}
	/**
	 * 设置PDM路径
	 */
	public void setPdmPath(String pdmPath) {
		this.pdmPath = pdmPath.replace("\\", "/");
	}
	/**
	 * 获取资源路径
	 */
	public String getResourcesPath() {
		return resourcesPath;
	}
	/**
	 * 设置资源路径
	 */
	public void setResourcesPath(String resourcesPath) {
		this.resourcesPath = resourcesPath.replace("\\", "/");
	}
	/**
	 * 获取模块组
	 * @return
	 */
	public String[] getModules() {
		return modules;
	}
	/**
	 * 设置设置模块组
	 * @param modules
	 */
	public void setModules(String[] modules) {
		this.modules = modules;
	}
	//endregion
	
	//region 其它方法
	/**
	 * 初始化数据
	 */
	public static List<ProjectXml> init() throws Exception{
		return readXml();
	}
	
	/**
	 * 读取XML文件获取对象
	 * @return
	 * @throws Exception
	 */
	public static List<ProjectXml> readXml() throws Exception{
		List<ProjectXml> projectXmlList = new ArrayList<ProjectXml>();
		
		File xmlFile = new File((new StringBuffer()).append(													
													Cache.getInstance().getRootPath())
													.append(File.separator)
													.append(ProjectXml.OBJECT_NAME)
													.append(".xml")
													.toString());
		if (!xmlFile.exists()){
			throw new Exception("系统缺失【" + xmlFile.getPath() +"】文件!");
		}
		else{
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();    
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(xmlFile);
			NodeList sysConfigTablesNodeList = doc.getElementsByTagName(TAG_SYSCONFIG_TABLE);
			String userName = "";
			for(int i = 0; i < sysConfigTablesNodeList.getLength(); i++){
				NodeList columnNodeList = sysConfigTablesNodeList.item(i).getChildNodes();
				for(int j = 0; j < columnNodeList.getLength(); j++){
					Node columnNode = columnNodeList.item(j);
					String nodeName = columnNode.getNodeName();
					if (TAG_USERNAME.equals(nodeName)){
						userName = columnNode.getTextContent();
					}
				}
			}
			
			NodeList projectTablesNodeList = doc.getElementsByTagName(TAG_PROJECT_TABLE);
			for(int i = 0; i < projectTablesNodeList.getLength(); i++){
				NodeList configNodeList = projectTablesNodeList.item(i).getChildNodes();
				for(int j = 0; j < configNodeList.getLength(); j++){
					NodeList columnNodeList = configNodeList.item(j).getChildNodes();
					ProjectXml projectXml = new ProjectXml();
					projectXml.setUserName(userName);
					for(int k = 0; k < columnNodeList.getLength(); k++){
						Node columnNode = columnNodeList.item(k);
						String nodeName = columnNode.getNodeName();
						if (TAG_ID.equals(nodeName)){
							projectXml.setId(columnNode.getTextContent());
						}
						else if (TAG_GROUPID.equals(nodeName)){
							projectXml.setGroupId(columnNode.getTextContent());
						}
						else if (TAG_ISCUSTOMSYS.equals(nodeName)){
							projectXml.setIsCustomSys(Boolean.parseBoolean(columnNode.getTextContent()));
						}
						else if (TAG_CNNAME.equals(nodeName)){
							projectXml.setCnName(columnNode.getTextContent());
						}
						else if (TAG_NAME.equals(nodeName)){
							projectXml.setName(columnNode.getTextContent());
						}
						else if (TAG_TYPE.equals(nodeName)){
							projectXml.setType(Integer.parseInt(columnNode.getTextContent()));
						}
						else if (TAG_PROJECTPATH.equals(nodeName)){
							projectXml.setProjectPath(columnNode.getTextContent());
						}
						else if (TAG_PDMPATH.equals(nodeName)){
							projectXml.setPdmPath(columnNode.getTextContent());
						}
						else if (TAG_RESOURCESPATH.equals(nodeName)){
							projectXml.setResourcesPath(columnNode.getTextContent());
						}
						else if (TAG_MODULES.equals(nodeName)){
							projectXml.setModules(columnNode.getTextContent().split(","));
						}
					}
					if (projectXml.getName() != null) projectXmlList.add(projectXml);
				}
			}			
		}
		return projectXmlList;
	}
	
	public String toString() {
		StringBuilder modulesStr = new StringBuilder();
		for(String module : modules){
			modulesStr.append(module).append("|");
		}
		if (modulesStr.length() > 0) modulesStr.deleteCharAt(modulesStr.length()-1);
		return (new StringBuffer()).append("[ ")
								   .append(TAG_ID).append(":")
								   .append(id).append(",")
								   .append(TAG_USERNAME).append(":")
								   .append(userName).append(",")
								   .append(TAG_GROUPID).append(":")
								   .append(groupId).append(",")
								   .append(TAG_NAME).append(":")
								   .append(name).append(",")
								   .append(TAG_TYPE).append(":")
								   .append(type).append(",")
								   .append(TAG_PDMPATH).append(":")
								   .append(pdmPath).append(",")
								   .append(TAG_RESOURCESPATH).append(":")
								   .append(resourcesPath).append(",")
								   .append(TAG_MODULES).append(":")
								   .append(modulesStr.toString())
								   .append(" ]")
								   .toString();
	}
	//endregion
}
