package com.googlecode.gendevcode.model.pdm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * 数据类型结构
 * @author devilishking
 *
 */
public class DataTypePdmXml {
	private Integer id;			  //编号
	private String dataType;	  //数据类型
	private String exchangeType;  //转换的数据类型
	private Boolean isMatch;	  //是否需要模糊匹配
	private String importClass;	  //需要导入类库
	private String remark;		  //自定义注释

	public DataTypePdmXml() {
		this.isMatch = false;
	}
	
	//region 标签
	/**
	 * 标签：表名
	 */
	public static final String TAG_TABLE = DataTypePdmXml.class.getSimpleName().toUpperCase();

	/**
	 * 标签：编号
	 */
	public static final String TAG_ID = "ID";
	/**
	 * 标签：数据类型
	 */
	public static final String TAG_DATATYPE = "DATATYPE";
	/**
	 * 标签：转换的数据类型
	 */
	public static final String TAG_EXCHANGETYPE = "EXCHANGETYPE";
	/**
	 * 标签：是否需要模糊匹配
	 */
	public static final String TAG_ISMATCH = "ISMATCH";
	/**
	 * 标签：需要导入类库
	 */
	public static final String TAG_IMPORTCLASS = "IMPORTCLASS";
	/**
	 * 标签：自定义注释
	 */
	public static final String TAG_REMARK = "REMARK";
	//endregion
	
	//region 属性GET、SET方法
	/**
	 * 获取编号
	 */
	public Integer getId() {
		return id;
	}
	/**
	 * 设置编号
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * 获取数据类型
	 */
	public String getDataType() {
		return dataType;
	}
	/**
	 * 设置数据类型
	 */
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	/**
	 * 获取转换的数据类型
	 */
	public String getExchangeType() {
		return exchangeType;
	}
	/**
	 * 设置转换的数据类型
	 */
	public void setExchangeType(String exchangeType) {
		this.exchangeType = exchangeType;
	}
	/**
	 * 获取是否需要模糊匹配
	 */
	public Boolean getIsMatch() {
		return isMatch;
	}
	/**
	 * 设置是否需要模糊匹配
	 */
	public void setIsMatch(Boolean isMatch) {
		this.isMatch = isMatch;
	}
	/**
	 * 获取需要导入类库
	 */
	public String getImportClass() {
		return importClass;
	}
	/**
	 * 设置需要导入类库
	 */
	public void setImportClass(String importClass) {
		this.importClass = importClass;
	}
	/**
	 * 获取自定义注释
	 */
	public String getRemark() {
		return remark;
	}
	/**
	 * 设置自定义注释
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}	
	//endregion

	//region 其它方法
	/**
	 * 初始化数据类型结构对象
	 * @param rootPath 系统根目录
	 * @return
	 * @throws Exception
	 */
	public static List<DataTypePdmXml> init() throws Exception{
		InputStream in = ClassLoader.getSystemResourceAsStream("dataTypePdmXml.xml");
		try{
			if (in != null){
				List<DataTypePdmXml> dataTypePdmXmlList = new ArrayList<DataTypePdmXml>();
				DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();    
				DocumentBuilder db = dbf.newDocumentBuilder();
				Document doc = db.parse(in);
				NodeList dataTypePdmXmlNodeList = doc.getElementsByTagName(TAG_TABLE);
				for(int i = 0; i < dataTypePdmXmlNodeList.getLength(); i++){
					DataTypePdmXml dataTypePdmXml = new DataTypePdmXml();
					NodeList columnNodeList = dataTypePdmXmlNodeList.item(i).getChildNodes();
					for(int j = 0; j < columnNodeList.getLength(); j++){
						Node columnNode = columnNodeList.item(j);
						String nodeName = columnNode.getNodeName();
						if (TAG_ID.equals(nodeName)){
							dataTypePdmXml.setId(Integer.parseInt(columnNode.getTextContent()));
						}
						else if (TAG_DATATYPE.equals(nodeName)){
							dataTypePdmXml.setDataType(columnNode.getTextContent());
						}
						else if (TAG_EXCHANGETYPE.equals(nodeName)){
							dataTypePdmXml.setExchangeType(columnNode.getTextContent());
						}
						else if (TAG_ISMATCH.equals(nodeName) && 
								columnNode.getTextContent() != null &&
								columnNode.getTextContent().trim().length() > 0){
							dataTypePdmXml.setIsMatch(Boolean.parseBoolean(columnNode.getTextContent()));
						}
						else if (TAG_IMPORTCLASS.equals(nodeName)){
							dataTypePdmXml.setImportClass(columnNode.getTextContent());
						}
						else if (TAG_REMARK.equals(nodeName)){
							dataTypePdmXml.setRemark(columnNode.getTextContent());
						}
					}
					dataTypePdmXmlList.add(dataTypePdmXml);
				}
				return dataTypePdmXmlList;
			}
			else{
				throw new Exception(String.format("%0$s文件不存在!", "dataTypePdmXml.xml"));
			}
		}
		finally{
			if (in != null) in.close();
		}
	}
	
	public String toString() {
		return (new StringBuffer()).append("[")
								   .append(TAG_ID).append(":")
								   .append(id).append(",")
								   .append(TAG_DATATYPE).append(":")
								   .append(dataType).append(",")
								   .append(TAG_EXCHANGETYPE).append(":")
								   .append(exchangeType).append(",")
								   .append(TAG_ISMATCH).append(":")
								   .append(isMatch).append(",")
								   .append(TAG_IMPORTCLASS).append(":")
								   .append(importClass).append(",")
								   .append(TAG_REMARK).append(":")
								   .append(remark)
								   .append("]")
								   .toString();
	}
	//endregion
}
