package com.googlecode.gendevcode.service;

import java.util.List;
import java.util.Map;

import com.googlecode.gendevcode.model.ProjectXml;
import com.googlecode.gendevcode.model.pdm.TablePdmXml;
import com.googlecode.gendevcode.model.pdm.ViewPdmXml;
import com.googlecode.gendevcode.service.basic.BaseService;

/**
 * 生成代码文件接口类
 * @author devilishking
 *
 */
public interface GenCodeFilesService extends BaseService {
	/**
	 * 创建Spring的hibernate配置文件信息
	 * @param tablePdmXmlList 待生成的表信息列表
	 * @param viewMap	                视图集合<视图编号, 视图信息>
	 * @param projectXml  	     项目信息
	 * @throws Exception
	 */
	public void genHibernateXml(List<TablePdmXml> tablePdmXmlList, Map<String, ViewPdmXml> viewMap, ProjectXml projectXml) throws Exception;
	/**
	 * 创建Spring的service配置文件信息
	 * @param tablePdmXmlList 待生成的表信息列表
	 * @param viewMap	                视图集合<视图编号, 视图信息>
	 * @param projectXml  	     项目信息
	 * @throws Exception
	 */
	public void genServiceXml(List<TablePdmXml> tablePdmXmlList, Map<String, ViewPdmXml> viewMap, ProjectXml projectXml) throws Exception;
	/**
	 * 创建字典文件
	 * @param tablePdmXmlList 待生成的表信息列表
	 * @param viewMap	                视图集合<视图编号, 视图信息>
	 * @param projectXml  	     项目信息
	 * @throws Exception
	 */
	public void genDictionaryXml(List<TablePdmXml> tablePdmXmlList, Map<String, ViewPdmXml> viewMap, ProjectXml projectXml) throws Exception;
	/**
	 * 创建代码文件  
	 * @param tablePdmXmlList 待生成的表信息列表
	 * @param viewMap	                视图集合<视图编号, 视图信息>
	 * @param genLevel 	                项目生成级别
	 * @param projectXml      项目信息
	 * @throws Exception
	 */
	public void genCodeFilesXml(List<TablePdmXml> tablePdmXmlList, Map<String, ViewPdmXml> viewMap, String genLevel, ProjectXml projectXml) throws Exception;
}